/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import akka.actor.ActorRef;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.controller.cluster.access.client.AbstractClientActorContext;

@Beta
public abstract class AbstractClientActorBehavior<C extends AbstractClientActorContext> {
    private final C context;

    AbstractClientActorBehavior(@Nonnull C context) {
        this.context = (AbstractClientActorContext)Preconditions.checkNotNull(context);
    }

    @Nonnull
    protected final C context() {
        return this.context;
    }

    @Nonnull
    protected final String persistenceId() {
        return ((AbstractClientActorContext)this.context).persistenceId();
    }

    @Nonnull
    public final ActorRef self() {
        return ((AbstractClientActorContext)this.context).self();
    }

    @Nullable
    abstract AbstractClientActorBehavior<?> onReceiveCommand(@Nonnull Object var1);

    @Nullable
    abstract AbstractClientActorBehavior<?> onReceiveRecover(@Nonnull Object var1);
}

