/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.opendaylight.controller.cluster.access.client.BackendInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class BackendInfoResolver<T extends BackendInfo> {
    private static final Logger LOG = LoggerFactory.getLogger(BackendInfoResolver.class);
    private final ConcurrentMap<Long, CompletableFuture<T>> backends = new ConcurrentHashMap<Long, CompletableFuture<T>>();

    public final Optional<T> getFutureBackendInfo(Long cookie) {
        CompletableFuture<T> f = this.lookupBackend(cookie);
        if (f.isDone()) {
            try {
                return Optional.of(f.get());
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.debug("Resolution of {} failed", f, (Object)e);
            }
        }
        return Optional.empty();
    }

    public final void invalidateBackend(long cookie, @Nonnull CompletionStage<? extends BackendInfo> info) {
        if (this.backends.remove(cookie, Preconditions.checkNotNull(info))) {
            LOG.trace("Invalidated cache %s -> %s", (Object)Long.toUnsignedString(cookie), info);
            this.invalidateBackendInfo(info);
        }
    }

    @Nonnull
    protected abstract CompletableFuture<T> resolveBackendInfo(@Nonnull Long var1);

    protected abstract void invalidateBackendInfo(@Nonnull CompletionStage<? extends BackendInfo> var1);

    final CompletionStage<? extends T> getBackendInfo(Long cookie) {
        return this.lookupBackend(cookie);
    }

    private CompletableFuture<T> lookupBackend(Long cookie) {
        return this.backends.computeIfAbsent((Long)Preconditions.checkNotNull((Object)cookie), this::resolveBackendInfo);
    }
}

