/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import com.google.common.annotations.Beta;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.controller.cluster.access.client.BackendInfo;
import org.opendaylight.controller.cluster.access.client.BackendInfoResolver;
import org.opendaylight.controller.cluster.access.client.ClientActorContext;
import org.opendaylight.controller.cluster.access.client.InternalCommand;
import org.opendaylight.controller.cluster.access.client.NoProgressException;
import org.opendaylight.controller.cluster.access.client.RecoveredClientActorBehavior;
import org.opendaylight.controller.cluster.access.client.RequestCallback;
import org.opendaylight.controller.cluster.access.client.SequencedQueue;
import org.opendaylight.controller.cluster.access.commands.TransactionRequest;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FailureEnvelope;
import org.opendaylight.controller.cluster.access.concepts.Request;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.RequestFailure;
import org.opendaylight.controller.cluster.access.concepts.ResponseEnvelope;
import org.opendaylight.controller.cluster.access.concepts.RetiredGenerationException;
import org.opendaylight.controller.cluster.access.concepts.SuccessEnvelope;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.duration.FiniteDuration;

@Beta
public abstract class ClientActorBehavior
extends RecoveredClientActorBehavior<ClientActorContext>
implements Identifiable<ClientIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(ClientActorBehavior.class);

    protected ClientActorBehavior(@Nonnull ClientActorContext context) {
        super(context);
    }

    @Nonnull
    public final ClientIdentifier getIdentifier() {
        return ((ClientActorContext)this.context()).getIdentifier();
    }

    final ClientActorBehavior onReceiveCommand(Object command) {
        if (command instanceof InternalCommand) {
            return ((InternalCommand)command).execute(this);
        }
        if (command instanceof SuccessEnvelope) {
            return this.onRequestSuccess((SuccessEnvelope)command);
        }
        if (command instanceof FailureEnvelope) {
            return this.onRequestFailure((FailureEnvelope)command);
        }
        return this.onCommand(command);
    }

    private ClientActorBehavior onRequestSuccess(SuccessEnvelope command) {
        return ((ClientActorContext)this.context()).completeRequest(this, (ResponseEnvelope<?>)command);
    }

    private ClientActorBehavior onRequestFailure(FailureEnvelope command) {
        RequestFailure failure = (RequestFailure)command.getMessage();
        RequestException cause = failure.getCause();
        if (cause instanceof RetiredGenerationException) {
            LOG.error("{}: current generation {} has been superseded", new Object[]{this.persistenceId(), this.getIdentifier(), cause});
            this.haltClient((Throwable)cause);
            ((ClientActorContext)this.context()).poison(cause);
            return null;
        }
        if (failure.isHardFailure()) {
            return ((ClientActorContext)this.context()).completeRequest(this, (ResponseEnvelope<?>)command);
        }
        LOG.warn("{}: Unhandled retriable failure {}, promoting to hard failure", (Object)this.persistenceId(), (Object)command);
        return ((ClientActorContext)this.context()).completeRequest(this, (ResponseEnvelope<?>)command);
    }

    private ClientActorBehavior doSendRequest(TransactionRequest<?> request, RequestCallback callback) {
        SequencedQueue queue = ((ClientActorContext)this.context()).queueFor(((TransactionIdentifier)request.getTarget()).getHistoryId().getCookie());
        Optional<FiniteDuration> result = queue.enqueueRequest((Request<?, ?>)request, callback);
        if (result == null) {
            return this;
        }
        if (result.isPresent()) {
            this.scheduleQueueTimeout(queue, result.get());
            return this;
        }
        this.startResolve(queue, ((TransactionIdentifier)request.getTarget()).getHistoryId().getCookie());
        return this;
    }

    private void startResolve(SequencedQueue queue, long cookie) {
        CompletionStage<?> f = this.resolver().getBackendInfo(cookie);
        if (queue.expectProof(f)) {
            f.thenAccept(backend -> ((ClientActorContext)this.context()).executeInActor(cb -> cb.finishResolve(queue, (CompletionStage<? extends BackendInfo>)f, (BackendInfo)backend)));
        }
    }

    private ClientActorBehavior finishResolve(SequencedQueue queue, CompletionStage<? extends BackendInfo> futureBackend, BackendInfo backend) {
        Optional<FiniteDuration> maybeTimeout = queue.setBackendInfo(futureBackend, backend);
        if (maybeTimeout.isPresent()) {
            this.scheduleQueueTimeout(queue, maybeTimeout.get());
        }
        return this;
    }

    private void scheduleQueueTimeout(SequencedQueue queue, FiniteDuration timeout) {
        LOG.debug("{}: scheduling timeout in {}", (Object)this.persistenceId(), (Object)timeout);
        ((ClientActorContext)this.context()).executeInActor(cb -> cb.queueTimeout(queue), timeout);
    }

    private ClientActorBehavior queueTimeout(SequencedQueue queue) {
        boolean needBackend;
        try {
            needBackend = queue.runTimeout();
        }
        catch (NoProgressException e) {
            ((ClientActorContext)this.context()).removeQueue(queue);
            return this;
        }
        if (needBackend) {
            this.startResolve(queue, queue.getCookie());
        }
        return this;
    }

    protected abstract void haltClient(@Nonnull Throwable var1);

    @Nullable
    protected abstract ClientActorBehavior onCommand(@Nonnull Object var1);

    @Nonnull
    protected abstract BackendInfoResolver<?> resolver();

    public final void sendRequest(TransactionRequest<?> request, RequestCallback callback) {
        ((ClientActorContext)this.context()).executeInActor(cb -> cb.doSendRequest(request, callback));
    }
}

