/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import akka.actor.ActorRef;
import akka.actor.Cancellable;
import akka.actor.Scheduler;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.opendaylight.controller.cluster.access.client.AbstractClientActorContext;
import org.opendaylight.controller.cluster.access.client.ClientActorBehavior;
import org.opendaylight.controller.cluster.access.client.InternalCommand;
import org.opendaylight.controller.cluster.access.client.SequencedQueue;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.Response;
import org.opendaylight.controller.cluster.access.concepts.ResponseEnvelope;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.concepts.WritableIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;

@Beta
@ThreadSafe
public class ClientActorContext
extends AbstractClientActorContext
implements Identifiable<ClientIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(ClientActorContext.class);
    private final Map<Long, SequencedQueue> queues = new ConcurrentHashMap<Long, SequencedQueue>();
    private final ClientIdentifier identifier;
    private final ExecutionContext executionContext;
    private final Scheduler scheduler;

    ClientActorContext(ActorRef self, Scheduler scheduler, ExecutionContext executionContext, String persistenceId, ClientIdentifier identifier) {
        super(self, persistenceId);
        this.identifier = (ClientIdentifier)Preconditions.checkNotNull((Object)identifier);
        this.scheduler = (Scheduler)Preconditions.checkNotNull((Object)scheduler);
        this.executionContext = (ExecutionContext)Preconditions.checkNotNull((Object)executionContext);
    }

    @Nonnull
    public ClientIdentifier getIdentifier() {
        return this.identifier;
    }

    @Nonnull
    public Ticker ticker() {
        return Ticker.systemTicker();
    }

    public void executeInActor(@Nonnull InternalCommand command) {
        this.self().tell(Preconditions.checkNotNull((Object)command), ActorRef.noSender());
    }

    public Cancellable executeInActor(@Nonnull InternalCommand command, FiniteDuration delay) {
        return this.scheduler.scheduleOnce((FiniteDuration)Preconditions.checkNotNull((Object)delay), this.self(), Preconditions.checkNotNull((Object)command), this.executionContext, ActorRef.noSender());
    }

    SequencedQueue queueFor(Long cookie) {
        return this.queues.computeIfAbsent(cookie, t -> new SequencedQueue((Long)t, this.ticker()));
    }

    void removeQueue(SequencedQueue queue) {
        this.queues.remove(queue.getCookie(), queue);
    }

    ClientActorBehavior completeRequest(ClientActorBehavior current, ResponseEnvelope<?> response) {
        WritableIdentifier id = ((Response)response.getMessage()).getTarget();
        Preconditions.checkArgument((boolean)(id instanceof TransactionIdentifier));
        TransactionIdentifier txId = (TransactionIdentifier)id;
        SequencedQueue queue = this.queues.get(txId.getHistoryId().getCookie());
        if (queue == null) {
            LOG.info("{}: Ignoring unknown response {}", (Object)this.persistenceId(), response);
            return current;
        }
        return queue.complete(current, response);
    }

    void poison(RequestException cause) {
        for (SequencedQueue q : this.queues.values()) {
            q.poison(cause);
        }
        this.queues.clear();
    }
}

