/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import akka.actor.ActorRef;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.opendaylight.controller.cluster.access.client.BackendInfo;
import org.opendaylight.controller.cluster.access.client.ClientActorBehavior;
import org.opendaylight.controller.cluster.access.client.RequestCallback;
import org.opendaylight.controller.cluster.access.client.TxDetails;
import org.opendaylight.controller.cluster.access.concepts.Request;
import org.opendaylight.controller.cluster.access.concepts.RequestEnvelope;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SequencedQueueEntry {
    private static final Logger LOG = LoggerFactory.getLogger(SequencedQueueEntry.class);
    private final Request<?, ?> request;
    private final RequestCallback callback;
    private final long enqueuedTicks;
    private TxDetails txDetails;

    SequencedQueueEntry(Request<?, ?> request, RequestCallback callback, long now) {
        this.request = (Request)Preconditions.checkNotNull(request);
        this.callback = (RequestCallback)Preconditions.checkNotNull((Object)callback);
        this.enqueuedTicks = now;
    }

    Request<?, ?> getRequest() {
        return this.request;
    }

    @Nullable
    TxDetails getTxDetails() {
        return this.txDetails;
    }

    ClientActorBehavior complete(Response<?, ?> response) {
        LOG.debug("Completing request {} with {}", this.request, response);
        return this.callback.complete(response);
    }

    void poison(RequestException cause) {
        LOG.trace("Poisoning request {}", this.request, (Object)cause);
        this.callback.complete((Response<?, ?>)this.request.toRequestFailure(cause));
    }

    boolean isTimedOut(long now, long timeoutNanos) {
        long elapsed = this.txDetails != null ? now - this.txDetails.getTimeTicks() : now - this.enqueuedTicks;
        if (elapsed >= timeoutNanos) {
            LOG.debug("Request {} timed out after {}ns", this.request, (Object)elapsed);
            return true;
        }
        return false;
    }

    void retransmit(BackendInfo backend, long txSequence, long now) {
        RequestEnvelope toSend = new RequestEnvelope((Request)this.request.toVersion(backend.getVersion()), backend.getSessionId(), txSequence);
        ActorRef actor = backend.getActor();
        LOG.trace("Transmitting request {} as {} to {}", new Object[]{this.request, toSend, actor});
        actor.tell((Object)toSend, ActorRef.noSender());
        this.txDetails = new TxDetails(backend.getSessionId(), txSequence, now);
    }

    public String toString() {
        return MoreObjects.toStringHelper(SequencedQueueEntry.class).add("request", this.request).toString();
    }
}

