/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import akka.actor.ActorRef;
import akka.actor.PoisonPill;
import akka.persistence.UntypedPersistentActor;
import com.google.common.annotations.Beta;
import org.opendaylight.controller.cluster.access.client.AbstractClientActorBehavior;
import org.opendaylight.controller.cluster.access.client.ClientActorBehavior;
import org.opendaylight.controller.cluster.access.client.ClientActorContext;
import org.opendaylight.controller.cluster.access.client.InitialClientActorContext;
import org.opendaylight.controller.cluster.access.client.RecoveringClientActorBehavior;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public abstract class AbstractClientActor
extends UntypedPersistentActor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractClientActor.class);
    private AbstractClientActorBehavior<?> currentBehavior;

    protected AbstractClientActor(FrontendIdentifier frontendId) {
        this.currentBehavior = new RecoveringClientActorBehavior(new InitialClientActorContext(this, frontendId.toPersistentId()), frontendId);
    }

    public final String persistenceId() {
        return this.currentBehavior.persistenceId();
    }

    private void switchBehavior(AbstractClientActorBehavior<?> nextBehavior) {
        if (!this.currentBehavior.equals(nextBehavior)) {
            if (nextBehavior == null) {
                LOG.debug("{}: shutting down", (Object)this.persistenceId());
                this.self().tell((Object)PoisonPill.getInstance(), ActorRef.noSender());
            } else {
                LOG.debug("{}: switched from {} to {}", new Object[]{this.persistenceId(), this.currentBehavior, nextBehavior});
            }
            this.currentBehavior = nextBehavior;
        }
    }

    public final void onReceiveCommand(Object command) {
        if (command == null) {
            LOG.debug("{}: ignoring null command", (Object)this.persistenceId());
            return;
        }
        if (this.currentBehavior != null) {
            this.switchBehavior(this.currentBehavior.onReceiveCommand(command));
        } else {
            LOG.debug("{}: shutting down, ignoring command {}", (Object)this.persistenceId(), command);
        }
    }

    public final void onReceiveRecover(Object recover) {
        this.switchBehavior(this.currentBehavior.onReceiveRecover(recover));
    }

    protected abstract ClientActorBehavior<?> initialBehavior(ClientActorContext var1);
}

