/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.opendaylight.controller.cluster.access.client.AbstractClientConnection;
import org.opendaylight.controller.cluster.access.client.BackendInfo;
import org.opendaylight.controller.cluster.access.client.ClientActorContext;
import org.opendaylight.controller.cluster.access.client.TransmitQueue;
import org.opendaylight.controller.cluster.access.concepts.ResponseEnvelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractReceivingClientConnection<T extends BackendInfo>
extends AbstractClientConnection<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractReceivingClientConnection.class);
    private static final int MESSAGE_QUEUE_FACTOR = 4;
    private final T backend;

    AbstractReceivingClientConnection(ClientActorContext context, Long cookie, T backend) {
        super(context, cookie, new TransmitQueue.Transmitting(AbstractReceivingClientConnection.targetQueueSize(backend), (BackendInfo)backend));
        this.backend = (BackendInfo)Preconditions.checkNotNull(backend);
    }

    AbstractReceivingClientConnection(AbstractReceivingClientConnection<T> oldConnection) {
        super(oldConnection, AbstractReceivingClientConnection.targetQueueSize(oldConnection.backend));
        this.backend = oldConnection.backend;
    }

    private static int targetQueueSize(BackendInfo backend) {
        return backend.getMaxMessages() * 4;
    }

    @Override
    public final Optional<T> getBackendInfo() {
        return Optional.of(this.backend);
    }

    @Override
    final void receiveResponse(ResponseEnvelope<?> envelope) {
        if (envelope.getSessionId() != ((BackendInfo)this.backend).getSessionId()) {
            LOG.debug("Response {} does not match session ID {}, ignoring it", envelope, (Object)((BackendInfo)this.backend).getSessionId());
        } else {
            super.receiveResponse(envelope);
        }
    }

    final T backend() {
        return this.backend;
    }

    @Override
    MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).add("backend", this.backend);
    }
}

