/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import akka.actor.ActorRef;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import org.opendaylight.controller.cluster.access.ABIVersion;

public class BackendInfo {
    private final ABIVersion version;
    private final ActorRef actor;
    private final int maxMessages;
    private final long sessionId;

    protected BackendInfo(ActorRef actor, long sessionId, ABIVersion version, int maxMessages) {
        this.version = (ABIVersion)Preconditions.checkNotNull((Object)version);
        this.actor = (ActorRef)Preconditions.checkNotNull((Object)actor);
        Preconditions.checkArgument((maxMessages > 0 ? 1 : 0) != 0, (String)"Maximum messages has to be positive, not %s", (Object[])new Object[]{maxMessages});
        this.maxMessages = maxMessages;
        this.sessionId = sessionId;
    }

    public final ActorRef getActor() {
        return this.actor;
    }

    public final ABIVersion getVersion() {
        return this.version;
    }

    public final int getMaxMessages() {
        return this.maxMessages;
    }

    public final long getSessionId() {
        return this.sessionId;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this).omitNullValues()).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("actor", (Object)this.actor).add("sessionId", this.sessionId).add("version", (Object)this.version).add("maxMessages", this.maxMessages);
    }
}

