/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import akka.actor.ActorRef;
import akka.actor.Cancellable;
import akka.actor.Scheduler;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.opendaylight.controller.cluster.access.client.AbstractClientActorContext;
import org.opendaylight.controller.cluster.access.client.BackendInfo;
import org.opendaylight.controller.cluster.access.client.InternalCommand;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.yangtools.concepts.Identifiable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;

@Beta
@ThreadSafe
public class ClientActorContext
extends AbstractClientActorContext
implements Identifiable<ClientIdentifier> {
    private final ExecutionContext executionContext;
    private final ClientIdentifier identifier;
    private final Scheduler scheduler;

    ClientActorContext(ActorRef self, Scheduler scheduler, ExecutionContext executionContext, String persistenceId, ClientIdentifier identifier) {
        super(self, persistenceId);
        this.identifier = (ClientIdentifier)Preconditions.checkNotNull((Object)identifier);
        this.scheduler = (Scheduler)Preconditions.checkNotNull((Object)scheduler);
        this.executionContext = (ExecutionContext)Preconditions.checkNotNull((Object)executionContext);
    }

    @Nonnull
    public ClientIdentifier getIdentifier() {
        return this.identifier;
    }

    @Nonnull
    public Ticker ticker() {
        return Ticker.systemTicker();
    }

    public <T extends BackendInfo> void executeInActor(@Nonnull InternalCommand<T> command) {
        this.self().tell(Preconditions.checkNotNull(command), ActorRef.noSender());
    }

    public <T extends BackendInfo> Cancellable executeInActor(@Nonnull InternalCommand<T> command, FiniteDuration delay) {
        return this.scheduler.scheduleOnce((FiniteDuration)Preconditions.checkNotNull((Object)delay), this.self(), Preconditions.checkNotNull(command), this.executionContext, ActorRef.noSender());
    }
}

