/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import com.google.common.annotations.Beta;
import javax.annotation.concurrent.NotThreadSafe;
import org.opendaylight.controller.cluster.access.client.AbstractReceivingClientConnection;
import org.opendaylight.controller.cluster.access.client.BackendInfo;
import org.opendaylight.controller.cluster.access.client.ClientActorBehavior;
import org.opendaylight.controller.cluster.access.client.ClientActorContext;
import org.opendaylight.controller.cluster.access.client.ReconnectingClientConnection;
import org.opendaylight.controller.cluster.access.client.SimpleReconnectForwarder;
import org.opendaylight.controller.cluster.access.concepts.RequestException;

@Beta
@NotThreadSafe
public final class ConnectedClientConnection<T extends BackendInfo>
extends AbstractReceivingClientConnection<T> {
    ConnectedClientConnection(ClientActorContext context, Long cookie, T backend) {
        super(context, cookie, backend);
    }

    @Override
    ClientActorBehavior<T> lockedReconnect(ClientActorBehavior<T> current, RequestException cause) {
        ReconnectingClientConnection next = new ReconnectingClientConnection(this, cause);
        this.setForwarder(new SimpleReconnectForwarder(next));
        current.reconnectConnection(this, next);
        return current;
    }
}

