/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import com.google.common.base.Preconditions;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
abstract class ProgressTracker {
    private static final Logger LOG = LoggerFactory.getLogger(ProgressTracker.class);
    private final long defaultTicksPerTask;
    private long tasksClosed = 0L;
    private long tasksEncountered = 0L;
    private long lastIdle = Long.MIN_VALUE;
    private long lastClosed = Long.MIN_VALUE;
    private long nearestAllowed = Long.MIN_VALUE;
    private long elapsedBeforeIdle = 0L;

    ProgressTracker(long ticksPerTask) {
        Preconditions.checkArgument((ticksPerTask >= 0L ? 1 : 0) != 0);
        this.defaultTicksPerTask = ticksPerTask;
    }

    ProgressTracker(ProgressTracker tracker) {
        this.defaultTicksPerTask = tracker.defaultTicksPerTask;
        this.tasksClosed = tracker.tasksClosed;
        this.tasksEncountered = tracker.tasksEncountered;
        this.lastClosed = tracker.lastClosed;
        this.lastIdle = tracker.lastIdle;
        this.nearestAllowed = tracker.nearestAllowed;
        this.elapsedBeforeIdle = tracker.elapsedBeforeIdle;
    }

    public final long defaultTicksPerTask() {
        return this.defaultTicksPerTask;
    }

    public final long tasksClosed() {
        return this.tasksClosed;
    }

    public final long tasksEncountered() {
        return this.tasksEncountered;
    }

    public final long tasksOpen() {
        return this.tasksEncountered - this.tasksClosed;
    }

    public boolean isIdle() {
        return this.tasksClosed >= this.tasksEncountered;
    }

    public long ticksStalling(long now) {
        return this.isIdle() ? 0L : Math.max(now, this.lastClosed) - this.lastClosed;
    }

    public long ticksWorked(long now) {
        return this.isIdle() ? this.elapsedBeforeIdle : Math.max(now, this.lastIdle) - this.lastIdle + this.elapsedBeforeIdle;
    }

    public double ticksWorkedPerClosedTask(long now) {
        if (this.tasksClosed < 1L) {
            return this.defaultTicksPerTask;
        }
        return (double)this.ticksWorked(now) / (double)this.tasksClosed;
    }

    public long estimateDelay(long now) {
        return this.estimateAllowed(now) - now;
    }

    public long estimateAllowed(long now) {
        return Math.max(now, this.nearestAllowed) + this.estimateIsolatedDelay(now);
    }

    public void closeTask(long now, long enqueuedTicks, long transmitTicks, long execNanos) {
        if (this.isIdle()) {
            LOG.info("Attempted to close a task while no tasks are open");
        } else {
            this.protectedCloseTask(now, enqueuedTicks, transmitTicks, execNanos);
        }
    }

    public long openTask(long now) {
        this.protectedOpenTask(now);
        return this.reserveDelay(now);
    }

    protected long reserveDelay(long now) {
        this.nearestAllowed = this.estimateAllowed(now);
        return this.nearestAllowed - now;
    }

    protected void protectedCloseTask(long now, long enqueuedTicks, long transmitTicks, long execNanos) {
        ++this.tasksClosed;
        this.lastClosed = now;
        if (this.isIdle()) {
            this.elapsedBeforeIdle += now - this.lastIdle;
        }
    }

    protected void protectedOpenTask(long now) {
        if (this.isIdle()) {
            this.lastIdle = Math.max(now, this.lastIdle);
        }
        ++this.tasksEncountered;
    }

    abstract long estimateIsolatedDelay(long var1);
}

