/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Cancellable;
import akka.actor.Scheduler;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.opendaylight.controller.cluster.access.client.AbstractClientActorContext;
import org.opendaylight.controller.cluster.access.client.BackendInfo;
import org.opendaylight.controller.cluster.access.client.ClientActorConfig;
import org.opendaylight.controller.cluster.access.client.InternalCommand;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.common.actor.Dispatchers;
import org.opendaylight.controller.cluster.io.FileBackedOutputStreamFactory;
import org.opendaylight.controller.cluster.messaging.MessageSlicer;
import org.opendaylight.yangtools.concepts.Identifiable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;

@Beta
@ThreadSafe
public class ClientActorContext
extends AbstractClientActorContext
implements Identifiable<ClientIdentifier> {
    private final ExecutionContext executionContext;
    private final ClientIdentifier identifier;
    private final Scheduler scheduler;
    private final Dispatchers dispatchers;
    private final ClientActorConfig config;
    private final MessageSlicer messageSlicer;

    ClientActorContext(ActorRef self, String persistenceId, ActorSystem system, ClientIdentifier identifier, ClientActorConfig config) {
        super(self, persistenceId);
        this.identifier = (ClientIdentifier)Preconditions.checkNotNull((Object)identifier);
        this.scheduler = ((ActorSystem)Preconditions.checkNotNull((Object)system)).scheduler();
        this.executionContext = system.dispatcher();
        this.dispatchers = new Dispatchers(system.dispatchers());
        this.config = (ClientActorConfig)Preconditions.checkNotNull((Object)config);
        this.messageSlicer = MessageSlicer.builder().messageSliceSize(config.getMaximumMessageSliceSize()).logContext(persistenceId).expireStateAfterInactivity(config.getRequestTimeout(), TimeUnit.NANOSECONDS).fileBackedStreamFactory(new FileBackedOutputStreamFactory(config.getFileBackedStreamingThreshold(), config.getTempFileDirectory())).build();
    }

    @Nonnull
    public ClientIdentifier getIdentifier() {
        return this.identifier;
    }

    @Nonnull
    public ClientActorConfig config() {
        return this.config;
    }

    @Nonnull
    public Dispatchers dispatchers() {
        return this.dispatchers;
    }

    @Nonnull
    public MessageSlicer messageSlicer() {
        return this.messageSlicer;
    }

    @Nonnull
    public Ticker ticker() {
        return Ticker.systemTicker();
    }

    public <T extends BackendInfo> void executeInActor(@Nonnull InternalCommand<T> command) {
        this.self().tell(Preconditions.checkNotNull(command), ActorRef.noSender());
    }

    public <T extends BackendInfo> Cancellable executeInActor(@Nonnull InternalCommand<T> command, FiniteDuration delay) {
        return this.scheduler.scheduleOnce((FiniteDuration)Preconditions.checkNotNull((Object)delay), this.self(), Preconditions.checkNotNull(command), this.executionContext, ActorRef.noSender());
    }
}

