/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.concurrent.CountDownLatch;

@Beta
public final class InversibleLockException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final transient CountDownLatch latch;

    InversibleLockException(CountDownLatch latch) {
        this.latch = (CountDownLatch)Preconditions.checkNotNull((Object)latch);
    }

    public void awaitResolution() {
        if (this.latch != null) {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Interrupted while waiting for latch " + this.latch, e);
            }
        }
    }
}

