/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import com.google.common.base.Preconditions;
import org.opendaylight.controller.cluster.access.client.AbstractReceivingClientConnection;
import org.opendaylight.controller.cluster.access.client.BackendInfo;
import org.opendaylight.controller.cluster.access.client.ClientActorBehavior;
import org.opendaylight.controller.cluster.access.client.ConnectedClientConnection;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReconnectingClientConnection<T extends BackendInfo>
extends AbstractReceivingClientConnection<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ReconnectingClientConnection.class);
    private RequestException cause;

    ReconnectingClientConnection(ConnectedClientConnection<T> oldConnection, RequestException cause) {
        super(oldConnection);
        this.cause = (RequestException)Preconditions.checkNotNull((Object)cause);
    }

    @Override
    long backendSilentTicks(long now) {
        return 0L;
    }

    @Override
    ClientActorBehavior<T> lockedReconnect(ClientActorBehavior<T> current, RequestException cause) {
        this.cause = (RequestException)Preconditions.checkNotNull((Object)cause);
        LOG.warn("Skipping reconnect of already-reconnecting connection {}", (Object)this);
        return current;
    }

    @Override
    RequestException enrichPoison(RequestException ex) {
        if (ex.getCause() != null) {
            ex.addSuppressed((Throwable)this.cause);
        } else {
            ex.initCause((Throwable)this.cause);
        }
        return ex;
    }
}

