/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.testkit.TestProbe;
import akka.testkit.javadsl.TestKit;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.OptionalLong;
import java.util.function.Consumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.opendaylight.controller.cluster.access.client.AbstractClientConnection;
import org.opendaylight.controller.cluster.access.client.AccessClientUtil;
import org.opendaylight.controller.cluster.access.client.BackendInfo;
import org.opendaylight.controller.cluster.access.client.ClientActorBehavior;
import org.opendaylight.controller.cluster.access.client.ClientActorContext;
import org.opendaylight.controller.cluster.access.client.ClientActorContextTest;
import org.opendaylight.controller.cluster.access.client.ConnectionEntry;
import org.opendaylight.controller.cluster.access.client.ConnectionEntryMatcher;
import org.opendaylight.controller.cluster.access.client.ReconnectForwarder;
import org.opendaylight.controller.cluster.access.commands.AbortLocalTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionAbortSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionFailure;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendType;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.access.concepts.Request;
import org.opendaylight.controller.cluster.access.concepts.RequestEnvelope;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.RequestSuccess;
import org.opendaylight.controller.cluster.access.concepts.Response;
import org.opendaylight.controller.cluster.access.concepts.ResponseEnvelope;
import org.opendaylight.controller.cluster.access.concepts.RuntimeRequestException;
import org.opendaylight.controller.cluster.access.concepts.SuccessEnvelope;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;

public abstract class AbstractClientConnectionTest<T extends AbstractClientConnection<U>, U extends BackendInfo> {
    protected static final MemberName MEMBER_NAME = MemberName.forName((String)"member-1");
    protected static final FrontendType FRONTEND_TYPE = FrontendType.forName((String)ClientActorContextTest.class.getSimpleName());
    protected static final FrontendIdentifier FRONTEND_ID = FrontendIdentifier.create((MemberName)MEMBER_NAME, (FrontendType)FRONTEND_TYPE);
    protected static final ClientIdentifier CLIENT_ID = ClientIdentifier.create((FrontendIdentifier)FRONTEND_ID, (long)0L);
    protected static final String PERSISTENCE_ID = "per-1";
    protected T connection;
    protected ClientActorContext context;
    protected ActorSystem system;
    protected TestProbe backendProbe;
    protected TestProbe contextProbe;
    protected TestProbe replyToProbe;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.system = ActorSystem.apply();
        this.backendProbe = new TestProbe(this.system);
        this.contextProbe = new TestProbe(this.system);
        this.context = new ClientActorContext(this.contextProbe.ref(), PERSISTENCE_ID, this.system, CLIENT_ID, AccessClientUtil.newMockClientActorConfig());
        this.replyToProbe = new TestProbe(this.system);
        this.connection = this.createConnection();
    }

    protected abstract T createConnection();

    @Test
    public void testLocalActor() {
        Assert.assertEquals((Object)this.contextProbe.ref(), (Object)this.connection.localActor());
    }

    @Test
    public abstract void testReconnectConnection();

    @Test
    public void testPoison() {
        Consumer callback = (Consumer)Mockito.mock(Consumer.class);
        Request<?, ?> request = this.createRequest(this.replyToProbe.ref());
        ConnectionEntry entry = new ConnectionEntry(request, callback, 0L);
        this.connection.enqueueEntry(entry, 0L);
        this.connection.poison((RequestException)new RuntimeRequestException("fail", (Throwable)new RuntimeException("fail")));
        ((Consumer)Mockito.verify((Object)callback, (VerificationMode)Mockito.timeout((long)1000L))).accept((Response)ArgumentMatchers.isA(TransactionFailure.class));
    }

    @Test
    public void testSendRequestReceiveResponse() {
        Consumer callback = (Consumer)Mockito.mock(Consumer.class);
        Request<?, ?> request = this.createRequest(this.replyToProbe.ref());
        this.connection.sendRequest(request, callback);
        RequestEnvelope requestEnvelope = (RequestEnvelope)this.backendProbe.expectMsgClass(RequestEnvelope.class);
        Assert.assertEquals(request, (Object)requestEnvelope.getMessage());
        LocalHistoryIdentifier historyId = new LocalHistoryIdentifier(CLIENT_ID, 0L);
        TransactionAbortSuccess message = new TransactionAbortSuccess(new TransactionIdentifier(historyId, 0L), 0L);
        SuccessEnvelope envelope = new SuccessEnvelope((RequestSuccess)message, 0L, 0L, 0L);
        this.connection.receiveResponse((ResponseEnvelope)envelope);
        ((Consumer)Mockito.verify((Object)callback, (VerificationMode)Mockito.timeout((long)1000L))).accept((Response)ArgumentMatchers.isA(TransactionAbortSuccess.class));
    }

    @Test
    public void testRun() {
        ClientActorBehavior behavior = (ClientActorBehavior)Mockito.mock(ClientActorBehavior.class);
        Assert.assertSame((Object)behavior, (Object)this.connection.runTimer(behavior));
    }

    @Test
    public void testCheckTimeoutEmptyQueue() {
        Assert.assertEquals((Object)OptionalLong.empty(), (Object)this.connection.checkTimeout(this.context.ticker().read()));
    }

    @Test
    public void testCheckTimeout() {
        Consumer callback = (Consumer)Mockito.mock(Consumer.class);
        this.connection.sendRequest(this.createRequest(this.replyToProbe.ref()), callback);
        long now = this.context.ticker().read();
        OptionalLong timeout = this.connection.checkTimeout(now);
        Assert.assertTrue((boolean)timeout.isPresent());
    }

    @Test
    public void testReplay() {
        Consumer callback = (Consumer)Mockito.mock(Consumer.class);
        Request<?, ?> request1 = this.createRequest(this.replyToProbe.ref());
        Request<?, ?> request2 = this.createRequest(this.replyToProbe.ref());
        this.connection.sendRequest(request1, callback);
        this.connection.sendRequest(request2, callback);
        Collection entries = this.connection.startReplay();
        MatcherAssert.assertThat((Object)entries, (Matcher)CoreMatchers.hasItems((Matcher[])new Matcher[]{ConnectionEntryMatcher.entryWithRequest(request1), ConnectionEntryMatcher.entryWithRequest(request2)}));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)entries));
        Iterables.removeIf((Iterable)entries, e -> true);
        ReconnectForwarder forwarder = (ReconnectForwarder)Mockito.mock(ReconnectForwarder.class);
        this.connection.finishReplay(forwarder);
    }

    @After
    public void tearDown() {
        TestKit.shutdownActorSystem((ActorSystem)this.system);
    }

    protected Request<?, ?> createRequest(ActorRef replyTo) {
        TransactionIdentifier identifier = new TransactionIdentifier(new LocalHistoryIdentifier(CLIENT_ID, 0L), 0L);
        return new AbortLocalTransactionRequest(identifier, replyTo);
    }
}

