/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import java.util.function.Consumer;
import org.mockito.Mockito;
import org.opendaylight.controller.cluster.access.client.AbstractClientConnection;
import org.opendaylight.controller.cluster.access.client.BackendInfo;
import org.opendaylight.controller.cluster.access.client.ClientActorConfig;
import org.opendaylight.controller.cluster.access.client.ClientActorContext;
import org.opendaylight.controller.cluster.access.client.ConnectedClientConnection;
import org.opendaylight.controller.cluster.access.client.ConnectingClientConnection;
import org.opendaylight.controller.cluster.access.client.ConnectionEntry;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.Request;
import org.opendaylight.controller.cluster.access.concepts.Response;
import org.opendaylight.controller.cluster.access.concepts.ResponseEnvelope;

public final class AccessClientUtil {
    private AccessClientUtil() {
        throw new UnsupportedOperationException();
    }

    public static ClientActorContext createClientActorContext(ActorSystem system, ActorRef actor, ClientIdentifier id, String persistenceId) {
        return (ClientActorContext)Mockito.spy((Object)new ClientActorContext(actor, persistenceId, system, id, AccessClientUtil.newMockClientActorConfig()));
    }

    public static ClientActorConfig newMockClientActorConfig() {
        ClientActorConfig mockConfig = (ClientActorConfig)Mockito.mock(ClientActorConfig.class);
        ((ClientActorConfig)Mockito.doReturn((Object)2000000).when((Object)mockConfig)).getMaximumMessageSliceSize();
        ((ClientActorConfig)Mockito.doReturn((Object)1000000000).when((Object)mockConfig)).getFileBackedStreamingThreshold();
        ((ClientActorConfig)Mockito.doReturn((Object)AbstractClientConnection.DEFAULT_BACKEND_ALIVE_TIMEOUT_NANOS).when((Object)mockConfig)).getBackendAlivenessTimerInterval();
        ((ClientActorConfig)Mockito.doReturn((Object)AbstractClientConnection.DEFAULT_REQUEST_TIMEOUT_NANOS).when((Object)mockConfig)).getRequestTimeout();
        ((ClientActorConfig)Mockito.doReturn((Object)AbstractClientConnection.DEFAULT_NO_PROGRESS_TIMEOUT_NANOS).when((Object)mockConfig)).getNoProgressTimeout();
        return mockConfig;
    }

    public static <T extends BackendInfo> ConnectedClientConnection<T> createConnectedConnection(ClientActorContext context, Long cookie, T backend) {
        return new ConnectedClientConnection((AbstractClientConnection)new ConnectingClientConnection(context, cookie, backend.getName()), backend);
    }

    public static void completeRequest(AbstractClientConnection<? extends BackendInfo> connection, ResponseEnvelope<?> envelope) {
        connection.receiveResponse(envelope);
    }

    public static ConnectionEntry createConnectionEntry(Request<?, ?> request, Consumer<Response<?, ?>> callback, long now) {
        return new ConnectionEntry(request, callback, now);
    }
}

