/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import com.google.common.testing.FakeTicker;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.controller.cluster.access.client.AveragingProgressTracker;

public class AveragingProgressTrackerTest {
    private static final long CHECKER = TimeUnit.MILLISECONDS.toNanos(500L);
    private static final long TICKER_STEP = 100L;
    private FakeTicker ticker;
    private AveragingProgressTracker averagingProgressTracker;

    @Before
    public void setUp() {
        this.ticker = new FakeTicker();
        this.ticker.setAutoIncrementStep(100L, TimeUnit.MILLISECONDS);
        this.averagingProgressTracker = new AveragingProgressTracker(3L);
    }

    @Test
    public void estimateIsolatedDelayTest() {
        long time = this.ticker.read();
        Assert.assertEquals((long)0L, (long)this.averagingProgressTracker.estimateIsolatedDelay(time));
        time = this.ticker.read();
        Assert.assertTrue((this.averagingProgressTracker.openTask(time) <= CHECKER ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)this.averagingProgressTracker.estimateIsolatedDelay(time));
        time = this.ticker.read();
        Assert.assertTrue((this.averagingProgressTracker.openTask(time) <= CHECKER ? 1 : 0) != 0);
        Assert.assertTrue((this.averagingProgressTracker.estimateIsolatedDelay(time) < CHECKER ? 1 : 0) != 0);
        time = this.ticker.read();
        Assert.assertTrue((this.averagingProgressTracker.openTask(time) >= CHECKER ? 1 : 0) != 0);
        Assert.assertEquals((long)CHECKER, (long)this.averagingProgressTracker.estimateIsolatedDelay(time));
        time = this.ticker.read();
        Assert.assertTrue((this.averagingProgressTracker.openTask(time) >= CHECKER ? 1 : 0) != 0);
        Assert.assertEquals((long)CHECKER, (long)this.averagingProgressTracker.estimateIsolatedDelay(time));
        this.averagingProgressTracker.closeTask(this.ticker.read(), 0L, 0L, 0L);
        this.averagingProgressTracker.closeTask(this.ticker.read(), 0L, 0L, 0L);
        this.averagingProgressTracker.closeTask(this.ticker.read(), 0L, 0L, 0L);
        Assert.assertEquals((long)0L, (long)this.averagingProgressTracker.estimateIsolatedDelay(this.ticker.read()));
    }
}

