/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import akka.actor.ActorSystem;
import akka.testkit.TestProbe;
import akka.testkit.javadsl.TestKit;
import com.google.common.base.Ticker;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.opendaylight.controller.cluster.access.client.AccessClientUtil;
import org.opendaylight.controller.cluster.access.client.BackendInfo;
import org.opendaylight.controller.cluster.access.client.ClientActorContext;
import org.opendaylight.controller.cluster.access.client.InternalCommand;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendType;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import scala.concurrent.duration.FiniteDuration;

public class ClientActorContextTest {
    private static final MemberName MEMBER_NAME = MemberName.forName((String)"member-1");
    private static final FrontendType FRONTEND_TYPE = FrontendType.forName((String)ClientActorContextTest.class.getSimpleName());
    private static final FrontendIdentifier FRONTEND_ID = FrontendIdentifier.create((MemberName)MEMBER_NAME, (FrontendType)FRONTEND_TYPE);
    private static final ClientIdentifier CLIENT_ID = ClientIdentifier.create((FrontendIdentifier)FRONTEND_ID, (long)0L);
    private static final String PERSISTENCE_ID = ClientActorContextTest.class.getSimpleName();
    @Mock
    private InternalCommand<? extends BackendInfo> command;
    private ActorSystem system;
    private TestProbe probe;
    private ClientActorContext ctx;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.system = ActorSystem.apply();
        this.probe = new TestProbe(this.system);
        this.ctx = new ClientActorContext(this.probe.ref(), PERSISTENCE_ID, this.system, CLIENT_ID, AccessClientUtil.newMockClientActorConfig());
    }

    @Test
    public void testMockingControl() {
        Assert.assertSame((Object)CLIENT_ID, (Object)this.ctx.getIdentifier());
        Assert.assertSame((Object)PERSISTENCE_ID, (Object)this.ctx.persistenceId());
        Assert.assertSame((Object)this.probe.ref(), (Object)this.ctx.self());
    }

    @Test
    public void testTicker() {
        Assert.assertSame((Object)Ticker.systemTicker(), (Object)this.ctx.ticker());
    }

    @Test
    public void testExecuteInActor() {
        this.ctx.executeInActor(this.command);
        this.probe.expectMsg(this.command);
    }

    @Test
    public void testExecuteInActorScheduled() {
        this.ctx.executeInActor(this.command, FiniteDuration.create((long)1L, (TimeUnit)TimeUnit.SECONDS));
        this.probe.expectMsg(this.command);
    }

    @After
    public void tearDown() {
        TestKit.shutdownActorSystem((ActorSystem)this.system);
    }
}

