/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import com.google.common.base.Ticker;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.cluster.access.client.AbstractTransmitQueueTest;
import org.opendaylight.controller.cluster.access.client.ConnectionEntry;
import org.opendaylight.controller.cluster.access.client.TransmitQueue;
import org.opendaylight.controller.cluster.access.commands.TransactionPurgeRequest;
import org.opendaylight.controller.cluster.access.concepts.Request;
import org.opendaylight.controller.cluster.access.concepts.Response;

public class HaltedTransmitQueueTest
extends AbstractTransmitQueueTest<TransmitQueue.Halted> {
    @Override
    protected int getMaxInFlightMessages() {
        return 0;
    }

    @Override
    protected TransmitQueue.Halted createQueue() {
        return new TransmitQueue.Halted(0);
    }

    @Override
    @Test
    public void testCanTransmitCount() {
        Assert.assertFalse((((TransmitQueue.Halted)this.queue).canTransmitCount(0) > 0 ? 1 : 0) != 0);
    }

    @Override
    @Test(expected=UnsupportedOperationException.class)
    public void testTransmit() {
        TransactionPurgeRequest request = new TransactionPurgeRequest(TRANSACTION_IDENTIFIER, 0L, this.probe.ref());
        Consumer<Response<?, ?>> callback = HaltedTransmitQueueTest.createConsumerMock();
        long now = Ticker.systemTicker().read();
        ConnectionEntry entry = new ConnectionEntry((Request)request, callback, now);
        ((TransmitQueue.Halted)this.queue).transmit(entry, now);
    }
}

