/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import akka.actor.ActorRef;
import com.google.common.testing.FakeTicker;
import org.junit.Before;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.opendaylight.controller.cluster.access.client.ClientActorContext;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendType;
import org.opendaylight.controller.cluster.access.concepts.MemberName;

public abstract class AbstractClientActorTest {
    private static final MemberName MEMBER_NAME = MemberName.forName((String)"member-1");
    @Mock
    private ClientActorContext mockActorContext;
    @Mock
    private ActorRef mockSelf;
    protected final FakeTicker ticker = new FakeTicker();

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        FrontendType frontendType = FrontendType.forName((String)this.getClass().getSimpleName());
        FrontendIdentifier frontendId = FrontendIdentifier.create((MemberName)MEMBER_NAME, (FrontendType)frontendType);
        ClientIdentifier clientId = ClientIdentifier.create((FrontendIdentifier)frontendId, (long)0L);
        ((ClientActorContext)Mockito.doReturn((Object)this.ticker).when((Object)this.mockActorContext)).ticker();
        ((ClientActorContext)Mockito.doReturn((Object)clientId).when((Object)this.mockActorContext)).getIdentifier();
        ((ClientActorContext)Mockito.doReturn((Object)this.getClass().getSimpleName()).when((Object)this.mockActorContext)).persistenceId();
        ((ClientActorContext)Mockito.doReturn((Object)this.mockSelf).when((Object)this.mockActorContext)).self();
    }

    protected final ClientActorContext actorContext() {
        return this.mockActorContext;
    }

    protected final ActorRef self() {
        return this.mockSelf;
    }
}

