/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.testkit.TestProbe;
import com.google.common.testing.FakeTicker;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.client.ClientActorBehavior;
import org.opendaylight.controller.cluster.access.client.ConnectionEntry;
import org.opendaylight.controller.cluster.access.concepts.AbstractRequestFailureProxy;
import org.opendaylight.controller.cluster.access.concepts.AbstractRequestProxy;
import org.opendaylight.controller.cluster.access.concepts.Request;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.RequestFailure;
import org.opendaylight.controller.cluster.access.concepts.Response;
import org.opendaylight.yangtools.concepts.WritableIdentifier;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class ConnectionEntryTest {
    @Mock
    private ActorRef mockReplyTo;
    @Mock
    private WritableIdentifier mockIdentifier;
    @Mock
    private RequestException mockCause;
    @Mock
    private Consumer<Response<?, ?>> mockCallback;
    @Mock
    private ClientActorBehavior<?> mockBehavior;
    private FakeTicker ticker;
    private Request<WritableIdentifier, ?> mockRequest;
    private Response<WritableIdentifier, ?> mockResponse;
    private static ActorSystem actorSystem;
    private TestProbe mockActor;
    private ConnectionEntry entry;

    @BeforeClass
    public static void setupClass() {
        actorSystem = ActorSystem.apply();
    }

    @AfterClass
    public static void teardownClass() {
        actorSystem.terminate();
    }

    @Before
    public void setup() {
        ((Consumer)Mockito.doNothing().when(this.mockCallback)).accept((Response)ArgumentMatchers.any(MockFailure.class));
        this.ticker = new FakeTicker();
        this.ticker.advance(ThreadLocalRandom.current().nextLong());
        this.mockActor = TestProbe.apply((ActorSystem)actorSystem);
        this.mockRequest = new MockRequest(this.mockIdentifier, this.mockReplyTo);
        this.mockResponse = this.mockRequest.toRequestFailure(this.mockCause);
        this.entry = new ConnectionEntry(this.mockRequest, this.mockCallback, this.ticker.read());
    }

    @After
    public void teardown() {
        actorSystem.stop(this.mockActor.ref());
    }

    @Test
    public void testComplete() {
        this.entry.complete(this.mockResponse);
        ((Consumer)Mockito.verify(this.mockCallback)).accept(this.mockResponse);
    }

    private static class MockRequest
    extends Request<WritableIdentifier, MockRequest> {
        private static final long serialVersionUID = 1L;

        MockRequest(WritableIdentifier target, ActorRef replyTo) {
            super(target, 0L, replyTo);
        }

        public RequestFailure<WritableIdentifier, ?> toRequestFailure(RequestException cause) {
            return new MockFailure(this.getTarget(), cause);
        }

        protected AbstractRequestProxy<WritableIdentifier, MockRequest> externalizableProxy(ABIVersion version) {
            return null;
        }

        protected MockRequest cloneAsVersion(ABIVersion version) {
            return this;
        }
    }

    private static class MockFailure
    extends RequestFailure<WritableIdentifier, MockFailure> {
        private static final long serialVersionUID = 1L;

        MockFailure(WritableIdentifier target, RequestException cause) {
            super(target, 0L, cause);
        }

        protected AbstractRequestFailureProxy<WritableIdentifier, MockFailure> externalizableProxy(ABIVersion version) {
            return null;
        }

        protected MockFailure cloneAsVersion(ABIVersion version) {
            return this;
        }
    }
}

