/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.controller.cluster.access.client.InversibleLock;
import org.opendaylight.controller.cluster.access.client.InversibleLockException;

public class InversibleLockTest {
    private InversibleLock lock;
    private ScheduledExecutorService executor;

    @Before
    public void setUp() {
        this.lock = new InversibleLock();
        this.executor = Executors.newScheduledThreadPool(1);
    }

    @After
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test(timeout=2000L)
    public void testWriteLockUnlock() {
        long stamp = this.lock.writeLock();
        Assert.assertTrue((boolean)this.lock.validate(stamp));
        this.executor.schedule(() -> this.lock.unlockWrite(stamp), 500L, TimeUnit.MILLISECONDS);
        try {
            this.lock.optimisticRead();
        }
        catch (InversibleLockException e) {
            e.awaitResolution();
        }
    }

    @Test
    public void testLockAfterRead() {
        long readStamp = this.lock.optimisticRead();
        this.lock.writeLock();
        Assert.assertFalse((boolean)this.lock.validate(readStamp));
    }
}

