/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import akka.actor.ActorRef;
import akka.dispatch.OnComplete;
import akka.pattern.Patterns;
import akka.persistence.SelectedSnapshot;
import akka.persistence.SnapshotMetadata;
import akka.persistence.SnapshotSelectionCriteria;
import akka.persistence.snapshot.japi.SnapshotStore;
import java.util.Objects;
import java.util.Optional;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.impl.Promise;

class MockedSnapshotStore
extends SnapshotStore {
    private static final long TIMEOUT = 1000L;
    private ActorRef delegate;

    MockedSnapshotStore() {
    }

    public Future<Optional<SelectedSnapshot>> doLoadAsync(String persistenceId, SnapshotSelectionCriteria criteria) {
        return this.askDelegate(new LoadRequest(persistenceId, criteria));
    }

    public Future<Void> doSaveAsync(SnapshotMetadata metadata, Object snapshot) {
        return this.askDelegate(new SaveRequest(metadata, snapshot));
    }

    public Future<Void> doDeleteAsync(SnapshotMetadata metadata) {
        return this.askDelegate(new DeleteByMetadataRequest(metadata));
    }

    public Future<Void> doDeleteAsync(String persistenceId, SnapshotSelectionCriteria criteria) {
        return this.askDelegate(new DeleteByCriteriaRequest(persistenceId, criteria));
    }

    public void unhandled(Object message) {
        if (message instanceof ActorRef) {
            this.delegate = (ActorRef)message;
            return;
        }
        super.unhandled(message);
    }

    private <T> Future<T> askDelegate(MockedSnapshotStoreMessage message) {
        return this.transform((Future<Object>)Patterns.ask((ActorRef)Objects.requireNonNull(this.delegate, "Delegate ref was not sent"), (Object)message, (long)1000L));
    }

    private <T> Future<T> transform(Future<Object> future) {
        Promise.DefaultPromise promise = new Promise.DefaultPromise();
        future.onComplete((Function1)new OnComplete<Object>((Promise)promise){
            final /* synthetic */ Promise val$promise;
            {
                this.val$promise = promise;
            }

            public void onComplete(Throwable failure, Object success) {
                if (success instanceof Throwable) {
                    this.val$promise.failure((Throwable)success);
                    return;
                }
                if (success == Void.TYPE) {
                    this.val$promise.success(null);
                    return;
                }
                this.val$promise.success(success);
            }
        }, (ExecutionContext)this.context().dispatcher());
        return promise.future();
    }

    class SaveRequest
    implements MockedSnapshotStoreMessage {
        private final SnapshotMetadata metadata;
        private final Object snapshot;

        SaveRequest(SnapshotMetadata metadata, Object snapshot) {
            this.metadata = metadata;
            this.snapshot = snapshot;
        }

        public SnapshotMetadata getMetadata() {
            return this.metadata;
        }

        public Object getSnapshot() {
            return this.snapshot;
        }
    }

    class DeleteByMetadataRequest
    implements MockedSnapshotStoreMessage {
        private final SnapshotMetadata metadata;

        DeleteByMetadataRequest(SnapshotMetadata metadata) {
            this.metadata = metadata;
        }

        public SnapshotMetadata getMetadata() {
            return this.metadata;
        }
    }

    class DeleteByCriteriaRequest
    implements MockedSnapshotStoreMessage {
        private final String persistenceId;
        private final SnapshotSelectionCriteria criteria;

        DeleteByCriteriaRequest(String persistenceId, SnapshotSelectionCriteria criteria) {
            this.persistenceId = persistenceId;
            this.criteria = criteria;
        }

        public String getPersistenceId() {
            return this.persistenceId;
        }

        public SnapshotSelectionCriteria getCriteria() {
            return this.criteria;
        }
    }

    class LoadRequest
    implements MockedSnapshotStoreMessage {
        private final String persistenceId;
        private final SnapshotSelectionCriteria criteria;

        LoadRequest(String persistenceId, SnapshotSelectionCriteria criteria) {
            this.persistenceId = persistenceId;
            this.criteria = criteria;
        }

        public String getPersistenceId() {
            return this.persistenceId;
        }

        public SnapshotSelectionCriteria getCriteria() {
            return this.criteria;
        }
    }

    static interface MockedSnapshotStoreMessage {
    }
}

