/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import akka.actor.ActorSystem;
import akka.testkit.TestProbe;
import akka.testkit.javadsl.TestKit;
import com.google.common.base.Ticker;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.opendaylight.controller.cluster.access.client.ConnectionEntry;
import org.opendaylight.controller.cluster.access.client.ConnectionEntryMatcher;
import org.opendaylight.controller.cluster.access.client.TransmitQueue;
import org.opendaylight.controller.cluster.access.commands.TransactionPurgeRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionPurgeResponse;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendType;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.access.concepts.Request;
import org.opendaylight.controller.cluster.access.concepts.RequestSuccess;
import org.opendaylight.controller.cluster.access.concepts.Response;
import org.opendaylight.controller.cluster.access.concepts.ResponseEnvelope;
import org.opendaylight.controller.cluster.access.concepts.SuccessEnvelope;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;

public abstract class AbstractTransmitQueueTest<T extends TransmitQueue> {
    private static final FrontendIdentifier FRONTEND = FrontendIdentifier.create((MemberName)MemberName.forName((String)"test"), (FrontendType)FrontendType.forName((String)"type-1"));
    private static final ClientIdentifier CLIENT = ClientIdentifier.create((FrontendIdentifier)FRONTEND, (long)0L);
    protected static final LocalHistoryIdentifier HISTORY = new LocalHistoryIdentifier(CLIENT, 0L);
    protected static final TransactionIdentifier TRANSACTION_IDENTIFIER = new TransactionIdentifier(HISTORY, 0L);
    protected T queue;
    protected ActorSystem system;
    protected TestProbe probe;

    protected abstract int getMaxInFlightMessages();

    protected abstract T createQueue();

    @Before
    public void setUp() {
        this.system = ActorSystem.apply();
        this.probe = new TestProbe(this.system);
        this.queue = this.createQueue();
    }

    @After
    public void tearDown() {
        TestKit.shutdownActorSystem((ActorSystem)this.system);
    }

    @Test
    public abstract void testCanTransmitCount();

    @Test(expected=UnsupportedOperationException.class)
    public abstract void testTransmit();

    @Test
    public void testAsIterable() {
        TransactionPurgeRequest request = new TransactionPurgeRequest(TRANSACTION_IDENTIFIER, 0L, this.probe.ref());
        Consumer<Response<?, ?>> callback = AbstractTransmitQueueTest.createConsumerMock();
        long now = Ticker.systemTicker().read();
        int sentMessages = this.getMaxInFlightMessages() + 1;
        for (int i = 0; i < sentMessages; ++i) {
            this.queue.enqueueOrForward(new ConnectionEntry((Request)request, callback, now), now);
        }
        Collection entries = this.queue.drain();
        Assert.assertEquals((long)sentMessages, (long)entries.size());
        MatcherAssert.assertThat((Object)entries, (Matcher)CoreMatchers.everyItem((Matcher)ConnectionEntryMatcher.entryWithRequest(request)));
    }

    @Test
    public void testTicksStalling() {
        long now = Ticker.systemTicker().read();
        Assert.assertEquals((long)0L, (long)this.queue.ticksStalling(now));
    }

    @Test
    public void testCompleteReponseNotMatchingRequest() {
        long requestSequence = 0L;
        long txSequence = 0L;
        long sessionId = 0L;
        TransactionPurgeRequest request = new TransactionPurgeRequest(TRANSACTION_IDENTIFIER, 0L, this.probe.ref());
        Consumer<Response<?, ?>> callback = AbstractTransmitQueueTest.createConsumerMock();
        long now = Ticker.systemTicker().read();
        this.queue.enqueueOrForward(new ConnectionEntry((Request)request, callback, now), now);
        TransactionIdentifier anotherTxId = new TransactionIdentifier(HISTORY, 1L);
        TransactionPurgeResponse success1 = new TransactionPurgeResponse(anotherTxId, 0L);
        Optional completed1 = this.queue.complete((ResponseEnvelope)new SuccessEnvelope((RequestSuccess)success1, 0L, 0L, 1L), now);
        Assert.assertFalse((boolean)completed1.isPresent());
        long differentResponseSequence = 1L;
        TransactionPurgeResponse success2 = new TransactionPurgeResponse(TRANSACTION_IDENTIFIER, 1L);
        Optional completed2 = this.queue.complete((ResponseEnvelope)new SuccessEnvelope((RequestSuccess)success2, 0L, 0L, 1L), now);
        Assert.assertFalse((boolean)completed2.isPresent());
        long differentTxSequence = 1L;
        TransactionPurgeResponse success3 = new TransactionPurgeResponse(TRANSACTION_IDENTIFIER, 0L);
        Optional completed3 = this.queue.complete((ResponseEnvelope)new SuccessEnvelope((RequestSuccess)success3, 0L, 1L, 1L), now);
        Assert.assertFalse((boolean)completed3.isPresent());
        long differentSessionId = 1L;
        TransactionPurgeResponse success4 = new TransactionPurgeResponse(TRANSACTION_IDENTIFIER, 0L);
        Optional completed4 = this.queue.complete((ResponseEnvelope)new SuccessEnvelope((RequestSuccess)success4, 1L, 1L, 1L), now);
        Assert.assertFalse((boolean)completed4.isPresent());
    }

    @Test
    public void testIsEmpty() {
        Assert.assertTrue((boolean)this.queue.isEmpty());
        TransactionPurgeRequest request = new TransactionPurgeRequest(TRANSACTION_IDENTIFIER, 0L, this.probe.ref());
        Consumer<Response<?, ?>> callback = AbstractTransmitQueueTest.createConsumerMock();
        long now = Ticker.systemTicker().read();
        this.queue.enqueueOrForward(new ConnectionEntry((Request)request, callback, now), now);
        Assert.assertFalse((boolean)this.queue.isEmpty());
    }

    @Test
    public void testPeek() {
        TransactionPurgeRequest request1 = new TransactionPurgeRequest(TRANSACTION_IDENTIFIER, 0L, this.probe.ref());
        TransactionPurgeRequest request2 = new TransactionPurgeRequest(TRANSACTION_IDENTIFIER, 1L, this.probe.ref());
        Consumer<Response<?, ?>> callback = AbstractTransmitQueueTest.createConsumerMock();
        long now = Ticker.systemTicker().read();
        ConnectionEntry entry1 = new ConnectionEntry((Request)request1, callback, now);
        ConnectionEntry entry2 = new ConnectionEntry((Request)request2, callback, now);
        this.queue.enqueueOrForward(entry1, now);
        this.queue.enqueueOrForward(entry2, now);
        Assert.assertEquals((Object)entry1.getRequest(), (Object)this.queue.peek().getRequest());
    }

    @Test
    public void testPoison() {
        TransactionPurgeRequest request = new TransactionPurgeRequest(TRANSACTION_IDENTIFIER, 0L, this.probe.ref());
        Consumer<Response<?, ?>> callback = AbstractTransmitQueueTest.createConsumerMock();
        long now = Ticker.systemTicker().read();
        this.queue.enqueueOrForward(new ConnectionEntry((Request)request, callback, now), now);
        Assert.assertEquals((long)1L, (long)this.queue.poison().size());
    }

    protected static Consumer<Response<?, ?>> createConsumerMock() {
        return (Consumer)Mockito.mock(Consumer.class);
    }
}

