/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ExtensionId;
import akka.actor.Props;
import akka.japi.Creator;
import akka.persistence.Persistence;
import akka.persistence.SelectedSnapshot;
import akka.persistence.SnapshotMetadata;
import akka.testkit.TestProbe;
import akka.testkit.javadsl.TestKit;
import com.typesafe.config.ConfigFactory;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opendaylight.controller.cluster.access.client.AbstractClientActor;
import org.opendaylight.controller.cluster.access.client.AbstractClientActorBehavior;
import org.opendaylight.controller.cluster.access.client.AbstractClientActorContext;
import org.opendaylight.controller.cluster.access.client.AccessClientUtil;
import org.opendaylight.controller.cluster.access.client.BackendInfo;
import org.opendaylight.controller.cluster.access.client.ClientActorBehavior;
import org.opendaylight.controller.cluster.access.client.ClientActorConfig;
import org.opendaylight.controller.cluster.access.client.ClientActorContext;
import org.opendaylight.controller.cluster.access.client.InternalCommand;
import org.opendaylight.controller.cluster.access.client.MockedSnapshotStore;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendType;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class ActorBehaviorTest {
    private static final String MEMBER_1_FRONTEND_TYPE_1 = "member-1-frontend-type-1";
    private static final FiniteDuration TIMEOUT = FiniteDuration.create((long)5L, (TimeUnit)TimeUnit.SECONDS);
    private ActorSystem system;
    private TestProbe probe;
    private ClientActorBehavior<BackendInfo> initialBehavior;
    private MockedSnapshotStore.SaveRequest saveRequest;
    private FrontendIdentifier id;
    private ActorRef mockedActor;

    @Before
    public void setUp() throws Exception {
        this.initialBehavior = ActorBehaviorTest.createInitialBehaviorMock();
        this.system = ActorSystem.apply((String)"system1");
        ActorRef storeRef = ((Persistence)this.system.registerExtension((ExtensionId)Persistence.lookup())).snapshotStoreFor(null, ConfigFactory.empty());
        this.probe = new TestProbe(this.system);
        storeRef.tell((Object)this.probe.ref(), ActorRef.noSender());
        MemberName name = MemberName.forName((String)"member-1");
        this.id = FrontendIdentifier.create((MemberName)name, (FrontendType)FrontendType.forName((String)"type-1"));
        this.mockedActor = this.system.actorOf(MockedActor.props(this.id, this.initialBehavior));
        this.saveRequest = this.handleRecovery(null);
    }

    @After
    public void tearDown() {
        TestKit.shutdownActorSystem((ActorSystem)this.system);
    }

    @Test
    public void testInitialBehavior() {
        InternalCommand cmd = (InternalCommand)Mockito.mock(InternalCommand.class);
        Mockito.when((Object)cmd.execute((ClientActorBehavior)ArgumentMatchers.any())).thenReturn(this.initialBehavior);
        this.mockedActor.tell((Object)cmd, ActorRef.noSender());
        ((InternalCommand)Mockito.verify((Object)cmd, (VerificationMode)Mockito.timeout((long)1000L))).execute(this.initialBehavior);
    }

    @Test
    public void testCommandStashing() {
        this.system.stop(this.mockedActor);
        this.mockedActor = this.system.actorOf(MockedActor.props(this.id, this.initialBehavior));
        InternalCommand cmd = (InternalCommand)Mockito.mock(InternalCommand.class);
        Mockito.when((Object)cmd.execute((ClientActorBehavior)ArgumentMatchers.any())).thenReturn(this.initialBehavior);
        this.mockedActor.tell((Object)cmd, ActorRef.noSender());
        this.mockedActor.tell((Object)cmd, ActorRef.noSender());
        this.mockedActor.tell((Object)cmd, ActorRef.noSender());
        this.handleRecovery(null);
        ((InternalCommand)Mockito.verify((Object)cmd, (VerificationMode)Mockito.timeout((long)1000L).times(3))).execute(this.initialBehavior);
    }

    @Test
    public void testRecoveryAfterRestart() {
        this.system.stop(this.mockedActor);
        this.mockedActor = this.system.actorOf(MockedActor.props(this.id, this.initialBehavior));
        MockedSnapshotStore.SaveRequest newSaveRequest = this.handleRecovery(new SelectedSnapshot(this.saveRequest.getMetadata(), this.saveRequest.getSnapshot()));
        Assert.assertEquals((Object)MEMBER_1_FRONTEND_TYPE_1, (Object)newSaveRequest.getMetadata().persistenceId());
    }

    @Test
    public void testRecoveryAfterRestartFrontendIdMismatch() {
        this.system.stop(this.mockedActor);
        this.mockedActor = this.system.actorOf(MockedActor.props(this.id, this.initialBehavior));
        this.probe.expectMsgClass(MockedSnapshotStore.LoadRequest.class);
        SnapshotMetadata metadata = this.saveRequest.getMetadata();
        FrontendIdentifier anotherFrontend = FrontendIdentifier.create((MemberName)MemberName.forName((String)"another"), (FrontendType)FrontendType.forName((String)"type-2"));
        ClientIdentifier incorrectClientId = ClientIdentifier.create((FrontendIdentifier)anotherFrontend, (long)0L);
        this.probe.watch(this.mockedActor);
        this.probe.reply(Optional.of(new SelectedSnapshot(metadata, (Object)incorrectClientId)));
        this.probe.expectTerminated(this.mockedActor, (Duration)TIMEOUT);
    }

    @Test
    public void testRecoveryAfterRestartSaveSnapshotFail() {
        this.system.stop(this.mockedActor);
        this.mockedActor = this.system.actorOf(MockedActor.props(this.id, this.initialBehavior));
        this.probe.watch(this.mockedActor);
        this.probe.expectMsgClass(MockedSnapshotStore.LoadRequest.class);
        this.probe.reply(Optional.empty());
        this.probe.expectMsgClass(MockedSnapshotStore.SaveRequest.class);
        this.probe.reply((Object)new RuntimeException("save failed"));
        this.probe.expectMsgClass(MockedSnapshotStore.DeleteByMetadataRequest.class);
        this.probe.expectTerminated(this.mockedActor, (Duration)TIMEOUT);
    }

    @Test
    public void testRecoveryAfterRestartDeleteSnapshotsFail() {
        this.system.stop(this.mockedActor);
        this.mockedActor = this.system.actorOf(MockedActor.props(this.id, this.initialBehavior));
        this.probe.watch(this.mockedActor);
        this.probe.expectMsgClass(MockedSnapshotStore.LoadRequest.class);
        this.probe.reply(Optional.empty());
        this.probe.expectMsgClass(MockedSnapshotStore.SaveRequest.class);
        this.probe.reply(Void.TYPE);
        this.probe.expectMsgClass(MockedSnapshotStore.DeleteByCriteriaRequest.class);
        this.probe.reply((Object)new RuntimeException("delete failed"));
        this.probe.expectNoMessage();
    }

    private static ClientActorBehavior<BackendInfo> createInitialBehaviorMock() throws Exception {
        ClientActorBehavior initialBehavior = (ClientActorBehavior)Mockito.mock(ClientActorBehavior.class);
        Field context = AbstractClientActorBehavior.class.getDeclaredField("context");
        context.setAccessible(true);
        AbstractClientActorContext ctx = (AbstractClientActorContext)Mockito.mock(AbstractClientActorContext.class);
        context.set(initialBehavior, ctx);
        Field persistenceId = AbstractClientActorContext.class.getDeclaredField("persistenceId");
        persistenceId.setAccessible(true);
        persistenceId.set(ctx, MEMBER_1_FRONTEND_TYPE_1);
        return initialBehavior;
    }

    private MockedSnapshotStore.SaveRequest handleRecovery(SelectedSnapshot savedState) {
        this.probe.expectMsgClass(MockedSnapshotStore.LoadRequest.class);
        this.probe.reply(Optional.ofNullable(savedState));
        MockedSnapshotStore.SaveRequest nextSaveRequest = (MockedSnapshotStore.SaveRequest)this.probe.expectMsgClass(MockedSnapshotStore.SaveRequest.class);
        this.probe.reply(Void.TYPE);
        this.probe.expectMsgClass(MockedSnapshotStore.DeleteByCriteriaRequest.class);
        this.probe.reply(Void.TYPE);
        return nextSaveRequest;
    }

    private static class MockedActor
    extends AbstractClientActor {
        private final ClientActorBehavior<?> initialBehavior;
        private final ClientActorConfig mockConfig = AccessClientUtil.newMockClientActorConfig();

        private static Props props(FrontendIdentifier frontendId, ClientActorBehavior<?> initialBehavior) {
            return Props.create(MockedActor.class, (Creator & Serializable)() -> new MockedActor(frontendId, initialBehavior));
        }

        MockedActor(FrontendIdentifier frontendId, ClientActorBehavior<?> initialBehavior) {
            super(frontendId);
            this.initialBehavior = initialBehavior;
        }

        protected ClientActorBehavior<?> initialBehavior(ClientActorContext context) {
            return this.initialBehavior;
        }

        protected ClientActorConfig getClientActorConfig() {
            return this.mockConfig;
        }
    }
}

