/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.client.AbstractClientConnection;
import org.opendaylight.controller.cluster.access.client.AbstractClientConnectionTest;
import org.opendaylight.controller.cluster.access.client.AccessClientUtil;
import org.opendaylight.controller.cluster.access.client.BackendInfo;
import org.opendaylight.controller.cluster.access.client.ClientActorBehavior;
import org.opendaylight.controller.cluster.access.client.ClientActorConfig;
import org.opendaylight.controller.cluster.access.client.ClientActorContext;
import org.opendaylight.controller.cluster.access.client.ConnectedClientConnection;
import org.opendaylight.controller.cluster.access.client.ConnectingClientConnection;
import org.opendaylight.controller.cluster.access.client.ReconnectingClientConnection;
import org.opendaylight.controller.cluster.access.commands.ModifyTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ModifyTransactionRequestBuilder;
import org.opendaylight.controller.cluster.access.commands.TransactionModification;
import org.opendaylight.controller.cluster.access.commands.TransactionWrite;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.Request;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.messaging.MessageSlice;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;

public class ConnectedClientConnectionTest
extends AbstractClientConnectionTest<ConnectedClientConnection<BackendInfo>, BackendInfo> {
    @Test
    public void testCheckTimeoutConnectionTimedout() {
        Consumer callback = (Consumer)Mockito.mock(Consumer.class);
        ((ConnectedClientConnection)this.connection).sendRequest(this.createRequest(this.replyToProbe.ref()), callback);
        long now = this.context.ticker().read() + ConnectedClientConnection.DEFAULT_BACKEND_ALIVE_TIMEOUT_NANOS;
        Assert.assertNull((Object)((ConnectedClientConnection)this.connection).checkTimeout(now));
    }

    @Override
    protected ConnectedClientConnection<BackendInfo> createConnection() {
        BackendInfo backend = new BackendInfo(this.backendProbe.ref(), "test", 0L, ABIVersion.BORON, 10);
        ConnectingClientConnection connectingConn = new ConnectingClientConnection(this.context, Long.valueOf(0L), backend.getName());
        return new ConnectedClientConnection((AbstractClientConnection)connectingConn, backend);
    }

    @Override
    @Test
    public void testReconnectConnection() {
        ClientActorBehavior behavior = (ClientActorBehavior)Mockito.mock(ClientActorBehavior.class);
        ((ConnectedClientConnection)this.connection).lockedReconnect(behavior, (RequestException)Mockito.mock(RequestException.class));
        ((ClientActorBehavior)Mockito.verify((Object)behavior)).reconnectConnection((ConnectedClientConnection)ArgumentMatchers.same((Object)((ConnectedClientConnection)this.connection)), (ReconnectingClientConnection)ArgumentMatchers.any(ReconnectingClientConnection.class));
    }

    @Test
    public void testSendSliceableMessageRequest() {
        ClientActorConfig config = AccessClientUtil.newMockClientActorConfig();
        ((ClientActorConfig)Mockito.doReturn((Object)5).when((Object)config)).getMaximumMessageSliceSize();
        this.context = new ClientActorContext(this.contextProbe.ref(), "per-1", this.system, CLIENT_ID, config);
        this.connection = this.createConnection();
        Consumer callback = (Consumer)Mockito.mock(Consumer.class);
        TransactionIdentifier identifier = new TransactionIdentifier(new LocalHistoryIdentifier(CLIENT_ID, 0L), 0L);
        ModifyTransactionRequestBuilder reqBuilder = new ModifyTransactionRequestBuilder(identifier, this.replyToProbe.ref());
        reqBuilder.addModification((TransactionModification)new TransactionWrite(YangInstanceIdentifier.empty(), Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((String)"namespace", (String)"localName"))).build()));
        reqBuilder.setSequence(0L);
        ModifyTransactionRequest request = reqBuilder.build();
        ((ConnectedClientConnection)this.connection).sendRequest((Request)request, callback);
        this.backendProbe.expectMsgClass(MessageSlice.class);
    }
}

