/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.testkit.TestProbe;
import com.google.common.testing.FakeTicker;
import java.util.OptionalLong;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.client.AbstractClientConnection;
import org.opendaylight.controller.cluster.access.client.AbstractReceivingClientConnection;
import org.opendaylight.controller.cluster.access.client.AccessClientUtil;
import org.opendaylight.controller.cluster.access.client.BackendInfo;
import org.opendaylight.controller.cluster.access.client.ClientActorBehavior;
import org.opendaylight.controller.cluster.access.client.ClientActorConfig;
import org.opendaylight.controller.cluster.access.client.ClientActorContext;
import org.opendaylight.controller.cluster.access.client.ConnectedClientConnection;
import org.opendaylight.controller.cluster.access.client.ConnectingClientConnection;
import org.opendaylight.controller.cluster.access.client.ReconnectForwarder;
import org.opendaylight.controller.cluster.access.client.SimpleReconnectForwarder;
import org.opendaylight.controller.cluster.access.concepts.AbstractRequestFailureProxy;
import org.opendaylight.controller.cluster.access.concepts.AbstractRequestProxy;
import org.opendaylight.controller.cluster.access.concepts.FailureEnvelope;
import org.opendaylight.controller.cluster.access.concepts.Request;
import org.opendaylight.controller.cluster.access.concepts.RequestEnvelope;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.RequestFailure;
import org.opendaylight.controller.cluster.access.concepts.Response;
import org.opendaylight.controller.cluster.access.concepts.ResponseEnvelope;
import org.opendaylight.controller.cluster.messaging.MessageSlicer;
import org.opendaylight.yangtools.concepts.WritableIdentifier;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

@RunWith(value=MockitoJUnitRunner.class)
public class ConnectingClientConnectionTest {
    @Mock
    private ActorRef mockReplyTo;
    @Mock
    private WritableIdentifier mockIdentifier;
    @Mock
    private RequestException mockCause;
    @Mock
    private Consumer<Response<?, ?>> mockCallback;
    @Mock
    private ClientActorBehavior<?> mockBehavior;
    @Mock
    private ClientActorContext mockContext;
    private FakeTicker ticker;
    private BackendInfo mockBackendInfo;
    private MockRequest mockRequest;
    private MockRequest mockRequest2;
    private RequestFailure<WritableIdentifier, ?> mockResponse;
    private FailureEnvelope mockResponseEnvelope;
    private Long mockCookie;
    private static ActorSystem actorSystem;
    private TestProbe mockActor;
    private AbstractClientConnection<?> queue;

    @BeforeClass
    public static void setupClass() {
        actorSystem = ActorSystem.apply();
    }

    @AfterClass
    public static void teardownClass() {
        actorSystem.terminate();
    }

    @Before
    public void setup() {
        ((Consumer)Mockito.doNothing().when(this.mockCallback)).accept((Response)ArgumentMatchers.any(MockFailure.class));
        this.ticker = new FakeTicker();
        this.ticker.advance(ThreadLocalRandom.current().nextLong());
        ((ClientActorContext)Mockito.doReturn((Object)this.ticker).when((Object)this.mockContext)).ticker();
        ClientActorConfig mockConfig = AccessClientUtil.newMockClientActorConfig();
        ((ClientActorContext)Mockito.doReturn((Object)mockConfig).when((Object)this.mockContext)).config();
        ((ClientActorContext)Mockito.doReturn((Object)Mockito.mock(MessageSlicer.class)).when((Object)this.mockContext)).messageSlicer();
        this.mockActor = TestProbe.apply((ActorSystem)actorSystem);
        this.mockBackendInfo = new BackendInfo(this.mockActor.ref(), "test", 0L, ABIVersion.current(), 5);
        this.mockRequest = new MockRequest(this.mockIdentifier, this.mockReplyTo);
        this.mockRequest2 = new MockRequest(this.mockIdentifier, this.mockReplyTo);
        this.mockResponse = this.mockRequest.toRequestFailure(this.mockCause);
        this.mockResponseEnvelope = new FailureEnvelope(this.mockResponse, 0L, 0L, 0L);
        this.mockCookie = ThreadLocalRandom.current().nextLong();
        this.queue = new ConnectingClientConnection(this.mockContext, this.mockCookie, this.mockBackendInfo.getName());
    }

    @After
    public void teardown() {
        actorSystem.stop(this.mockActor.ref());
    }

    @Test
    public void testCookie() {
        Assert.assertEquals((Object)this.mockCookie, (Object)this.queue.cookie());
    }

    @Test
    public void testPoison() {
        this.queue.sendRequest((Request)this.mockRequest, this.mockCallback);
        this.queue.poison(this.mockCause);
        ArgumentCaptor captor = ArgumentCaptor.forClass(MockFailure.class);
        ((Consumer)Mockito.verify(this.mockCallback)).accept((Response)captor.capture());
        Assert.assertSame((Object)this.mockCause, (Object)((MockFailure)((Object)captor.getValue())).getCause());
    }

    @Test(expected=IllegalStateException.class)
    public void testPoisonPerformsClose() {
        this.queue.poison(this.mockCause);
        this.queue.sendRequest((Request)this.mockRequest, this.mockCallback);
    }

    @Test
    public void testPoisonIdempotent() {
        this.queue.poison(this.mockCause);
        this.queue.poison(this.mockCause);
    }

    @Test
    public void testSendRequestNeedsBackend() {
        this.queue.sendRequest((Request)this.mockRequest, this.mockCallback);
        OptionalLong ret = this.queue.checkTimeout(this.ticker.read());
        Assert.assertNotNull((Object)ret);
        Assert.assertTrue((boolean)ret.isPresent());
    }

    @Test
    public void testSetBackendWithNoRequests() {
        this.setupBackend();
    }

    @Test
    public void testSendRequestNeedsTimer() {
        this.setupBackend();
        this.queue.sendRequest((Request)this.mockRequest, this.mockCallback);
        OptionalLong ret = this.queue.checkTimeout(this.ticker.read());
        Assert.assertNotNull((Object)ret);
        Assert.assertTrue((boolean)ret.isPresent());
        this.assertTransmit(this.mockRequest, 0L);
    }

    @Test
    public void testRunTimeoutEmpty() {
        OptionalLong ret = this.queue.checkTimeout(this.ticker.read());
        Assert.assertNotNull((Object)ret);
        Assert.assertFalse((boolean)ret.isPresent());
    }

    @Test
    public void testRunTimeoutWithoutShift() {
        this.queue.sendRequest((Request)this.mockRequest, this.mockCallback);
        OptionalLong ret = this.queue.checkTimeout(this.ticker.read());
        Assert.assertNotNull((Object)ret);
        Assert.assertTrue((boolean)ret.isPresent());
    }

    @Test
    public void testRunTimeoutWithTimeoutLess() {
        this.queue.sendRequest((Request)this.mockRequest, this.mockCallback);
        this.ticker.advance(AbstractClientConnection.DEFAULT_BACKEND_ALIVE_TIMEOUT_NANOS - 1L);
        OptionalLong ret = this.queue.checkTimeout(this.ticker.read());
        Assert.assertNotNull((Object)ret);
        Assert.assertTrue((boolean)ret.isPresent());
    }

    @Test
    public void testRunTimeoutWithTimeoutExact() {
        this.setupBackend();
        this.queue.sendRequest((Request)this.mockRequest, this.mockCallback);
        this.ticker.advance(AbstractClientConnection.DEFAULT_BACKEND_ALIVE_TIMEOUT_NANOS);
        OptionalLong ret = this.queue.checkTimeout(this.ticker.read());
        Assert.assertNull((Object)ret);
    }

    @Test
    public void testRunTimeoutWithTimeoutMore() {
        this.setupBackend();
        this.queue.sendRequest((Request)this.mockRequest, this.mockCallback);
        this.ticker.advance(AbstractClientConnection.DEFAULT_BACKEND_ALIVE_TIMEOUT_NANOS + 1L);
        Assert.assertNull((Object)this.queue.checkTimeout(this.ticker.read()));
    }

    public void testRunTimeoutWithoutProgressExact() {
        this.queue.sendRequest((Request)this.mockRequest, this.mockCallback);
        this.ticker.advance(AbstractClientConnection.DEFAULT_NO_PROGRESS_TIMEOUT_NANOS);
        this.queue.runTimer(this.mockBehavior);
        Assert.assertNotNull((Object)this.queue.poisoned());
    }

    public void testRunTimeoutWithoutProgressMore() {
        this.queue.sendRequest((Request)this.mockRequest, this.mockCallback);
        this.ticker.advance(AbstractClientConnection.DEFAULT_NO_PROGRESS_TIMEOUT_NANOS + 1L);
        this.queue.runTimer(this.mockBehavior);
        Assert.assertNotNull((Object)this.queue.poisoned());
    }

    @Test
    public void testRunTimeoutEmptyWithoutProgressExact() {
        this.ticker.advance(AbstractClientConnection.DEFAULT_NO_PROGRESS_TIMEOUT_NANOS);
        Assert.assertEquals((Object)OptionalLong.empty(), (Object)this.queue.checkTimeout(this.ticker.read()));
    }

    @Test
    public void testRunTimeoutEmptyWithoutProgressMore() {
        this.ticker.advance(AbstractClientConnection.DEFAULT_NO_PROGRESS_TIMEOUT_NANOS + 1L);
        Assert.assertEquals((Object)OptionalLong.empty(), (Object)this.queue.checkTimeout(this.ticker.read()));
    }

    @Test
    public void testCompleteEmpty() {
        this.queue.receiveResponse((ResponseEnvelope)this.mockResponseEnvelope);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockCallback});
    }

    @Test
    public void testCompleteSingle() {
        this.setupBackend();
        this.queue.sendRequest((Request)this.mockRequest, this.mockCallback);
        this.queue.receiveResponse((ResponseEnvelope)this.mockResponseEnvelope);
        ((Consumer)Mockito.verify(this.mockCallback)).accept(this.mockResponse);
        this.queue.receiveResponse((ResponseEnvelope)this.mockResponseEnvelope);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockCallback});
    }

    @Test
    public void testCompleteNull() {
        this.setupBackend();
        this.queue.sendRequest((Request)this.mockRequest, this.mockCallback);
        ((Consumer)Mockito.doNothing().when(this.mockCallback)).accept(this.mockResponse);
        this.queue.receiveResponse((ResponseEnvelope)this.mockResponseEnvelope);
        ((Consumer)Mockito.verify(this.mockCallback)).accept(this.mockResponse);
    }

    @Test
    public void testProgressRecord() {
        this.setupBackend();
        this.queue.sendRequest((Request)this.mockRequest, this.mockCallback);
        this.ticker.advance(10L);
        this.queue.sendRequest((Request)this.mockRequest2, this.mockCallback);
        this.queue.receiveResponse((ResponseEnvelope)this.mockResponseEnvelope);
        this.ticker.advance(AbstractClientConnection.DEFAULT_NO_PROGRESS_TIMEOUT_NANOS - 11L);
        Assert.assertNull((Object)this.queue.checkTimeout(this.ticker.read()));
    }

    private void setupBackend() {
        ConnectingClientConnection connectingConn = new ConnectingClientConnection(this.mockContext, this.mockCookie, "test");
        ConnectedClientConnection connectedConn = new ConnectedClientConnection((AbstractClientConnection)connectingConn, this.mockBackendInfo);
        this.queue.setForwarder((ReconnectForwarder)new SimpleReconnectForwarder((AbstractReceivingClientConnection)connectedConn));
        this.queue = connectedConn;
    }

    private void assertTransmit(Request<?, ?> expected, long sequence) {
        Assert.assertTrue((boolean)this.mockActor.msgAvailable());
        ConnectingClientConnectionTest.assertRequestEquals(expected, sequence, this.mockActor.receiveOne((Duration)FiniteDuration.apply((long)5L, (TimeUnit)TimeUnit.SECONDS)));
    }

    private static void assertRequestEquals(Request<?, ?> expected, long sequence, Object obj) {
        Assert.assertTrue((boolean)(obj instanceof RequestEnvelope));
        RequestEnvelope actual = (RequestEnvelope)obj;
        Assert.assertEquals((long)0L, (long)actual.getSessionId());
        Assert.assertEquals((long)sequence, (long)actual.getTxSequence());
        Assert.assertSame(expected, (Object)actual.getMessage());
    }

    private static class MockRequest
    extends Request<WritableIdentifier, MockRequest> {
        private static final long serialVersionUID = 1L;

        MockRequest(WritableIdentifier target, ActorRef replyTo) {
            super(target, 0L, replyTo);
        }

        public RequestFailure<WritableIdentifier, ?> toRequestFailure(RequestException cause) {
            return new MockFailure(this.getTarget(), cause);
        }

        protected AbstractRequestProxy<WritableIdentifier, MockRequest> externalizableProxy(ABIVersion version) {
            return null;
        }

        protected MockRequest cloneAsVersion(ABIVersion version) {
            return this;
        }
    }

    private static class MockFailure
    extends RequestFailure<WritableIdentifier, MockFailure> {
        private static final long serialVersionUID = 1L;

        MockFailure(WritableIdentifier target, RequestException cause) {
            super(target, 0L, cause);
        }

        protected AbstractRequestFailureProxy<WritableIdentifier, MockFailure> externalizableProxy(ABIVersion version) {
            return null;
        }

        protected MockFailure cloneAsVersion(ABIVersion version) {
            return this;
        }
    }
}

