/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import java.util.OptionalLong;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.client.AbstractClientConnection;
import org.opendaylight.controller.cluster.access.client.AbstractClientConnectionTest;
import org.opendaylight.controller.cluster.access.client.BackendInfo;
import org.opendaylight.controller.cluster.access.client.ClientActorBehavior;
import org.opendaylight.controller.cluster.access.client.ConnectedClientConnection;
import org.opendaylight.controller.cluster.access.client.ConnectingClientConnection;
import org.opendaylight.controller.cluster.access.client.ReconnectingClientConnection;
import org.opendaylight.controller.cluster.access.commands.TransactionAbortSuccess;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.Request;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.RequestSuccess;
import org.opendaylight.controller.cluster.access.concepts.Response;
import org.opendaylight.controller.cluster.access.concepts.ResponseEnvelope;
import org.opendaylight.controller.cluster.access.concepts.SuccessEnvelope;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;

public class ReconnectingClientConnectionTest
extends AbstractClientConnectionTest<ReconnectingClientConnection<BackendInfo>, BackendInfo> {
    @Test
    public void testCheckTimeoutConnectionTimedout() {
        Consumer callback = (Consumer)Mockito.mock(Consumer.class);
        ((ReconnectingClientConnection)this.connection).sendRequest(this.createRequest(this.replyToProbe.ref()), callback);
        long now = this.context.ticker().read() + ConnectedClientConnection.DEFAULT_BACKEND_ALIVE_TIMEOUT_NANOS;
        OptionalLong timeout = ((ReconnectingClientConnection)this.connection).checkTimeout(now);
        Assert.assertNotNull((Object)timeout);
        Assert.assertTrue((boolean)timeout.isPresent());
    }

    @Override
    protected ReconnectingClientConnection<BackendInfo> createConnection() {
        BackendInfo backend = new BackendInfo(this.backendProbe.ref(), "test", 0L, ABIVersion.BORON, 10);
        ConnectingClientConnection connectingConn = new ConnectingClientConnection(this.context, Long.valueOf(0L), backend.getName());
        ConnectedClientConnection connectedConn = new ConnectedClientConnection((AbstractClientConnection)connectingConn, backend);
        return new ReconnectingClientConnection(connectedConn, (RequestException)Mockito.mock(RequestException.class));
    }

    @Override
    @Test
    public void testReconnectConnection() {
        ClientActorBehavior behavior = (ClientActorBehavior)Mockito.mock(ClientActorBehavior.class);
        Assert.assertSame((Object)behavior, (Object)((ReconnectingClientConnection)this.connection).lockedReconnect(behavior, (RequestException)Mockito.mock(RequestException.class)));
    }

    @Override
    @Test
    public void testSendRequestReceiveResponse() {
        Consumer callback = (Consumer)Mockito.mock(Consumer.class);
        Request<?, ?> request = this.createRequest(this.replyToProbe.ref());
        ((ReconnectingClientConnection)this.connection).sendRequest(request, callback);
        this.backendProbe.expectNoMessage();
        LocalHistoryIdentifier historyId = new LocalHistoryIdentifier(CLIENT_ID, 0L);
        TransactionAbortSuccess message = new TransactionAbortSuccess(new TransactionIdentifier(historyId, 0L), 0L);
        SuccessEnvelope envelope = new SuccessEnvelope((RequestSuccess)message, 0L, 0L, 0L);
        ((ReconnectingClientConnection)this.connection).receiveResponse((ResponseEnvelope)envelope);
        ((Consumer)Mockito.verify((Object)callback, (VerificationMode)Mockito.after((long)1000L).never())).accept((Response)ArgumentMatchers.any());
    }
}

