/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import com.google.common.base.Ticker;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.testing.FakeTicker;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.client.AbstractTransmitQueueTest;
import org.opendaylight.controller.cluster.access.client.BackendInfo;
import org.opendaylight.controller.cluster.access.client.ConnectionEntry;
import org.opendaylight.controller.cluster.access.client.ConnectionEntryMatcher;
import org.opendaylight.controller.cluster.access.client.ReconnectForwarder;
import org.opendaylight.controller.cluster.access.client.TransmitQueue;
import org.opendaylight.controller.cluster.access.client.TransmittedConnectionEntry;
import org.opendaylight.controller.cluster.access.commands.ModifyTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ModifyTransactionRequestBuilder;
import org.opendaylight.controller.cluster.access.commands.TransactionPurgeRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionPurgeResponse;
import org.opendaylight.controller.cluster.access.concepts.FailureEnvelope;
import org.opendaylight.controller.cluster.access.concepts.Request;
import org.opendaylight.controller.cluster.access.concepts.RequestEnvelope;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.RequestSuccess;
import org.opendaylight.controller.cluster.access.concepts.Response;
import org.opendaylight.controller.cluster.access.concepts.ResponseEnvelope;
import org.opendaylight.controller.cluster.access.concepts.SuccessEnvelope;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.messaging.MessageSlicer;
import org.opendaylight.controller.cluster.messaging.SliceOptions;

public class TransmittingTransmitQueueTest
extends AbstractTransmitQueueTest<TransmitQueue.Transmitting> {
    private BackendInfo backendInfo;
    private final MessageSlicer mockMessageSlicer = (MessageSlicer)Mockito.mock(MessageSlicer.class);

    private static long now() {
        return Ticker.systemTicker().read();
    }

    @Override
    protected int getMaxInFlightMessages() {
        return this.backendInfo.getMaxMessages();
    }

    @Override
    protected TransmitQueue.Transmitting createQueue() {
        ((MessageSlicer)Mockito.doReturn((Object)false).when((Object)this.mockMessageSlicer)).slice((SliceOptions)ArgumentMatchers.any());
        this.backendInfo = new BackendInfo(this.probe.ref(), "test", 0L, ABIVersion.BORON, 3);
        return new TransmitQueue.Transmitting((TransmitQueue)new TransmitQueue.Halted(0), 0, this.backendInfo, TransmittingTransmitQueueTest.now(), this.mockMessageSlicer);
    }

    @Test
    public void testComplete() {
        long sequence1 = 0L;
        long sequence2 = 1L;
        TransactionPurgeRequest request1 = new TransactionPurgeRequest(TRANSACTION_IDENTIFIER, 0L, this.probe.ref());
        TransactionIdentifier transactionIdentifier2 = new TransactionIdentifier(HISTORY, 1L);
        TransactionPurgeRequest request2 = new TransactionPurgeRequest(transactionIdentifier2, 1L, this.probe.ref());
        Consumer<Response<?, ?>> callback1 = TransmittingTransmitQueueTest.createConsumerMock();
        Consumer<Response<?, ?>> callback2 = TransmittingTransmitQueueTest.createConsumerMock();
        long now1 = TransmittingTransmitQueueTest.now();
        long now2 = TransmittingTransmitQueueTest.now();
        ((TransmitQueue.Transmitting)this.queue).enqueueOrForward(new ConnectionEntry((Request)request1, callback1, now1), now1);
        ((TransmitQueue.Transmitting)this.queue).enqueueOrForward(new ConnectionEntry((Request)request2, callback2, now2), now2);
        TransactionPurgeResponse success1 = new TransactionPurgeResponse(TRANSACTION_IDENTIFIER, 0L);
        TransactionPurgeResponse success2 = new TransactionPurgeResponse(transactionIdentifier2, 1L);
        Optional completed2 = ((TransmitQueue.Transmitting)this.queue).complete((ResponseEnvelope)new SuccessEnvelope((RequestSuccess)success2, 0L, 1L, 1L), now2);
        Optional completed1 = ((TransmitQueue.Transmitting)this.queue).complete((ResponseEnvelope)new SuccessEnvelope((RequestSuccess)success1, 0L, 0L, 1L), now1);
        TransmittedConnectionEntry transmittedEntry1 = (TransmittedConnectionEntry)completed1.orElseThrow(AssertionError::new);
        Assert.assertEquals((Object)transmittedEntry1.getRequest(), (Object)request1);
        Assert.assertEquals((long)transmittedEntry1.getTxSequence(), (long)0L);
        Assert.assertEquals((Object)transmittedEntry1.getCallback(), callback1);
        TransmittedConnectionEntry transmittedEntry2 = (TransmittedConnectionEntry)completed2.orElseThrow(AssertionError::new);
        Assert.assertEquals((Object)transmittedEntry2.getRequest(), (Object)request2);
        Assert.assertEquals((long)transmittedEntry2.getTxSequence(), (long)1L);
        Assert.assertEquals((Object)transmittedEntry2.getCallback(), callback2);
    }

    @Test
    public void testEnqueueCanTransmit() {
        TransactionPurgeRequest request = new TransactionPurgeRequest(TRANSACTION_IDENTIFIER, 0L, this.probe.ref());
        Consumer<Response<?, ?>> callback = TransmittingTransmitQueueTest.createConsumerMock();
        long now = TransmittingTransmitQueueTest.now();
        ((TransmitQueue.Transmitting)this.queue).enqueueOrForward(new ConnectionEntry((Request)request, callback, now), now);
        RequestEnvelope requestEnvelope = (RequestEnvelope)this.probe.expectMsgClass(RequestEnvelope.class);
        Assert.assertEquals((Object)request, (Object)requestEnvelope.getMessage());
    }

    @Test
    public void testEnqueueBackendFull() {
        int i;
        TransactionPurgeRequest request = new TransactionPurgeRequest(TRANSACTION_IDENTIFIER, 0L, this.probe.ref());
        Consumer<Response<?, ?>> callback = TransmittingTransmitQueueTest.createConsumerMock();
        long now = TransmittingTransmitQueueTest.now();
        int sentMessages = this.getMaxInFlightMessages() + 1;
        for (i = 0; i < sentMessages; ++i) {
            ((TransmitQueue.Transmitting)this.queue).enqueueOrForward(new ConnectionEntry((Request)request, callback, now), now);
        }
        for (i = 0; i < this.getMaxInFlightMessages(); ++i) {
            this.probe.expectMsgClass(RequestEnvelope.class);
        }
        this.probe.expectNoMessage();
        Collection entries = ((TransmitQueue.Transmitting)this.queue).drain();
        Assert.assertEquals((long)sentMessages, (long)entries.size());
        MatcherAssert.assertThat((Object)entries, (Matcher)CoreMatchers.everyItem((Matcher)ConnectionEntryMatcher.entryWithRequest(request)));
    }

    @Override
    @Test
    public void testCanTransmitCount() {
        Assert.assertTrue((((TransmitQueue.Transmitting)this.queue).canTransmitCount(this.getMaxInFlightMessages() - 1) > 0 ? 1 : 0) != 0);
        Assert.assertFalse((((TransmitQueue.Transmitting)this.queue).canTransmitCount(this.getMaxInFlightMessages()) > 0 ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testTransmit() {
        TransactionPurgeRequest request = new TransactionPurgeRequest(TRANSACTION_IDENTIFIER, 0L, this.probe.ref());
        Consumer<Response<?, ?>> callback = TransmittingTransmitQueueTest.createConsumerMock();
        long now = TransmittingTransmitQueueTest.now();
        ConnectionEntry entry = new ConnectionEntry((Request)request, callback, now);
        Optional transmitted = ((TransmitQueue.Transmitting)this.queue).transmit(entry, now);
        Assert.assertTrue((boolean)transmitted.isPresent());
        Assert.assertEquals((Object)request, (Object)((TransmittedConnectionEntry)transmitted.get()).getRequest());
        Assert.assertEquals(callback, (Object)((TransmittedConnectionEntry)transmitted.get()).getCallback());
        RequestEnvelope requestEnvelope = (RequestEnvelope)this.probe.expectMsgClass(RequestEnvelope.class);
        Assert.assertEquals((Object)request, (Object)requestEnvelope.getMessage());
        transmitted = ((TransmitQueue.Transmitting)this.queue).transmit(new ConnectionEntry((Request)new TransactionPurgeRequest(TRANSACTION_IDENTIFIER, 1L, this.probe.ref()), callback, now), now);
        Assert.assertTrue((boolean)transmitted.isPresent());
    }

    @Test
    public void testSetForwarder() {
        FakeTicker ticker = new FakeTicker();
        ticker.setAutoIncrementStep(1L, TimeUnit.MICROSECONDS);
        TransactionPurgeRequest request = new TransactionPurgeRequest(TRANSACTION_IDENTIFIER, 0L, this.probe.ref());
        Consumer<Response<?, ?>> callback = TransmittingTransmitQueueTest.createConsumerMock();
        ConnectionEntry entry = new ConnectionEntry((Request)request, callback, ticker.read());
        ReconnectForwarder forwarder = (ReconnectForwarder)Mockito.mock(ReconnectForwarder.class);
        ((TransmitQueue.Transmitting)this.queue).setForwarder(forwarder, ticker.read());
        long secondEnqueueNow = ticker.read();
        ((TransmitQueue.Transmitting)this.queue).enqueueOrForward(entry, secondEnqueueNow);
        ((ReconnectForwarder)Mockito.verify((Object)forwarder)).forwardEntry(entry, secondEnqueueNow);
    }

    @Test
    public void testCompleteOrdering() {
        TransactionPurgeRequest req0 = new TransactionPurgeRequest(TRANSACTION_IDENTIFIER, 0L, this.probe.ref());
        TransactionPurgeRequest req1 = new TransactionPurgeRequest(TRANSACTION_IDENTIFIER, 1L, this.probe.ref());
        TransactionPurgeRequest req2 = new TransactionPurgeRequest(TRANSACTION_IDENTIFIER, 2L, this.probe.ref());
        TransactionPurgeRequest req3 = new TransactionPurgeRequest(TRANSACTION_IDENTIFIER, 3L, this.probe.ref());
        TransactionPurgeRequest req4 = new TransactionPurgeRequest(TRANSACTION_IDENTIFIER, 4L, this.probe.ref());
        TransactionPurgeRequest req5 = new TransactionPurgeRequest(TRANSACTION_IDENTIFIER, 5L, this.probe.ref());
        TransactionPurgeRequest req6 = new TransactionPurgeRequest(TRANSACTION_IDENTIFIER, 6L, this.probe.ref());
        Consumer<Response<?, ?>> callback = TransmittingTransmitQueueTest.createConsumerMock();
        ((TransmitQueue.Transmitting)this.queue).enqueueOrForward(new ConnectionEntry((Request)req0, callback, 0L), 0L);
        ((TransmitQueue.Transmitting)this.queue).enqueueOrForward(new ConnectionEntry((Request)req1, callback, 0L), 0L);
        ((TransmitQueue.Transmitting)this.queue).enqueueOrForward(new ConnectionEntry((Request)req2, callback, 0L), 0L);
        ((TransmitQueue.Transmitting)this.queue).enqueueOrForward(new ConnectionEntry((Request)req3, callback, 0L), 0L);
        TransmittingTransmitQueueTest.assertEqualRequests(((TransmitQueue.Transmitting)this.queue).getInflight(), new Request[]{req0, req1, req2});
        TransmittingTransmitQueueTest.assertEqualRequests(((TransmitQueue.Transmitting)this.queue).getPending(), new Request[]{req3});
        ((TransmitQueue.Transmitting)this.queue).complete((ResponseEnvelope)new FailureEnvelope(req0.toRequestFailure((RequestException)Mockito.mock(RequestException.class)), 0L, 0L, 0L), 0L);
        TransmittingTransmitQueueTest.assertEqualRequests(((TransmitQueue.Transmitting)this.queue).getInflight(), new Request[]{req1, req2, req3});
        TransmittingTransmitQueueTest.assertEqualRequests(((TransmitQueue.Transmitting)this.queue).getPending(), new Request[0]);
        ((TransmitQueue.Transmitting)this.queue).complete((ResponseEnvelope)new FailureEnvelope(req1.toRequestFailure((RequestException)Mockito.mock(RequestException.class)), 0L, 1L, 0L), 0L);
        TransmittingTransmitQueueTest.assertEqualRequests(((TransmitQueue.Transmitting)this.queue).getInflight(), new Request[]{req2, req3});
        TransmittingTransmitQueueTest.assertEqualRequests(((TransmitQueue.Transmitting)this.queue).getPending(), new Request[0]);
        ((TransmitQueue.Transmitting)this.queue).enqueueOrForward(new ConnectionEntry((Request)req4, callback, 0L), 0L);
        TransmittingTransmitQueueTest.assertEqualRequests(((TransmitQueue.Transmitting)this.queue).getInflight(), new Request[]{req2, req3, req4});
        TransmittingTransmitQueueTest.assertEqualRequests(((TransmitQueue.Transmitting)this.queue).getPending(), new Request[0]);
        ((TransmitQueue.Transmitting)this.queue).enqueueOrForward(new ConnectionEntry((Request)req5, callback, 0L), 0L);
        TransmittingTransmitQueueTest.assertEqualRequests(((TransmitQueue.Transmitting)this.queue).getInflight(), new Request[]{req2, req3, req4});
        TransmittingTransmitQueueTest.assertEqualRequests(((TransmitQueue.Transmitting)this.queue).getPending(), new Request[]{req5});
        ((TransmitQueue.Transmitting)this.queue).getInflight().removeLast();
        TransmittingTransmitQueueTest.assertEqualRequests(((TransmitQueue.Transmitting)this.queue).getInflight(), new Request[]{req2, req3});
        TransmittingTransmitQueueTest.assertEqualRequests(((TransmitQueue.Transmitting)this.queue).getPending(), new Request[]{req5});
        ((TransmitQueue.Transmitting)this.queue).enqueueOrForward(new ConnectionEntry((Request)req6, callback, 0L), 0L);
        TransmittingTransmitQueueTest.assertEqualRequests(((TransmitQueue.Transmitting)this.queue).getInflight(), new Request[]{req2, req3, req5});
        TransmittingTransmitQueueTest.assertEqualRequests(((TransmitQueue.Transmitting)this.queue).getPending(), new Request[]{req6});
    }

    @Test
    public void testRequestSlicingOnTransmit() {
        ((MessageSlicer)Mockito.doReturn((Object)true).when((Object)this.mockMessageSlicer)).slice((SliceOptions)ArgumentMatchers.any());
        ModifyTransactionRequestBuilder reqBuilder = new ModifyTransactionRequestBuilder(TRANSACTION_IDENTIFIER, this.probe.ref());
        reqBuilder.setSequence(0L);
        ModifyTransactionRequest request = reqBuilder.build();
        long now = TransmittingTransmitQueueTest.now();
        Consumer<Response<?, ?>> mockConsumer = TransmittingTransmitQueueTest.createConsumerMock();
        Optional transmitted = ((TransmitQueue.Transmitting)this.queue).transmit(new ConnectionEntry((Request)request, mockConsumer, now), now);
        Assert.assertTrue((boolean)transmitted.isPresent());
        ArgumentCaptor sliceOptions = ArgumentCaptor.forClass(SliceOptions.class);
        ((MessageSlicer)Mockito.verify((Object)this.mockMessageSlicer)).slice((SliceOptions)sliceOptions.capture());
        Assert.assertTrue((boolean)(((SliceOptions)sliceOptions.getValue()).getMessage() instanceof RequestEnvelope));
        RequestEnvelope requestEnvelope = (RequestEnvelope)((SliceOptions)sliceOptions.getValue()).getMessage();
        Assert.assertEquals((Object)request, (Object)requestEnvelope.getMessage());
        TransactionPurgeRequest request2 = new TransactionPurgeRequest(TRANSACTION_IDENTIFIER, 1L, this.probe.ref());
        transmitted = ((TransmitQueue.Transmitting)this.queue).transmit(new ConnectionEntry((Request)request2, mockConsumer, now), now);
        Assert.assertFalse((boolean)transmitted.isPresent());
    }

    @Test
    public void testSlicingFailureOnTransmit() {
        ((MessageSlicer)Mockito.doAnswer(invocation -> {
            ((SliceOptions)invocation.getArgument(0)).getOnFailureCallback().accept(new Exception("mock"));
            return Boolean.FALSE;
        }).when((Object)this.mockMessageSlicer)).slice((SliceOptions)ArgumentMatchers.any());
        ModifyTransactionRequestBuilder reqBuilder = new ModifyTransactionRequestBuilder(TRANSACTION_IDENTIFIER, this.probe.ref());
        reqBuilder.setSequence(0L);
        long now = TransmittingTransmitQueueTest.now();
        Optional transmitted = ((TransmitQueue.Transmitting)this.queue).transmit(new ConnectionEntry((Request)reqBuilder.build(), TransmittingTransmitQueueTest.createConsumerMock(), now), now);
        Assert.assertTrue((boolean)transmitted.isPresent());
        ((MessageSlicer)Mockito.verify((Object)this.mockMessageSlicer)).slice((SliceOptions)ArgumentMatchers.any());
        this.probe.expectMsgClass(FailureEnvelope.class);
    }

    @Test
    public void testSlicedRequestOnComplete() {
        ((MessageSlicer)Mockito.doReturn((Object)true).when((Object)this.mockMessageSlicer)).slice((SliceOptions)ArgumentMatchers.any());
        ModifyTransactionRequestBuilder reqBuilder = new ModifyTransactionRequestBuilder(TRANSACTION_IDENTIFIER, this.probe.ref());
        reqBuilder.setSequence(0L);
        ModifyTransactionRequest request = reqBuilder.build();
        long now = TransmittingTransmitQueueTest.now();
        Consumer<Response<?, ?>> mockConsumer = TransmittingTransmitQueueTest.createConsumerMock();
        ((TransmitQueue.Transmitting)this.queue).enqueueOrForward(new ConnectionEntry((Request)request, mockConsumer, now), now);
        ArgumentCaptor sliceOptions = ArgumentCaptor.forClass(SliceOptions.class);
        ((MessageSlicer)Mockito.verify((Object)this.mockMessageSlicer)).slice((SliceOptions)sliceOptions.capture());
        Assert.assertTrue((boolean)(((SliceOptions)sliceOptions.getValue()).getMessage() instanceof RequestEnvelope));
        TransactionPurgeRequest request2 = new TransactionPurgeRequest(TRANSACTION_IDENTIFIER, 1L, this.probe.ref());
        ((TransmitQueue.Transmitting)this.queue).enqueueOrForward(new ConnectionEntry((Request)request2, mockConsumer, now), now);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockMessageSlicer});
        this.probe.expectNoMessage();
        RequestEnvelope requestEnvelope = (RequestEnvelope)((SliceOptions)sliceOptions.getValue()).getMessage();
        ((TransmitQueue.Transmitting)this.queue).complete((ResponseEnvelope)new FailureEnvelope(request.toRequestFailure((RequestException)Mockito.mock(RequestException.class)), requestEnvelope.getSessionId(), requestEnvelope.getTxSequence(), 0L), 0L);
        requestEnvelope = (RequestEnvelope)this.probe.expectMsgClass(RequestEnvelope.class);
        Assert.assertEquals((Object)request2, (Object)requestEnvelope.getMessage());
        TransactionPurgeRequest request3 = new TransactionPurgeRequest(TRANSACTION_IDENTIFIER, 3L, this.probe.ref());
        ((TransmitQueue.Transmitting)this.queue).enqueueOrForward(new ConnectionEntry((Request)request3, mockConsumer, now), now);
        requestEnvelope = (RequestEnvelope)this.probe.expectMsgClass(RequestEnvelope.class);
        Assert.assertEquals((Object)request3, (Object)requestEnvelope.getMessage());
    }

    private static void assertEqualRequests(Collection<? extends ConnectionEntry> queue, Request<?, ?> ... requests) {
        ImmutableList queued = ImmutableList.copyOf((Collection)Collections2.transform(queue, ConnectionEntry::getRequest));
        Assert.assertEquals(Arrays.asList(requests), (Object)queued);
    }
}

