/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import akka.actor.ActorSystem;
import akka.persistence.SnapshotSelectionCriteria;
import java.util.Objects;
import org.opendaylight.controller.cluster.access.client.AbstractClientActor;
import org.opendaylight.controller.cluster.access.client.AbstractClientActorContext;
import org.opendaylight.controller.cluster.access.client.ClientActorBehavior;
import org.opendaylight.controller.cluster.access.client.ClientActorContext;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;

final class InitialClientActorContext
extends AbstractClientActorContext {
    private final AbstractClientActor actor;

    InitialClientActorContext(AbstractClientActor actor, String persistenceId) {
        super(actor.self(), persistenceId);
        this.actor = Objects.requireNonNull(actor);
    }

    void saveSnapshot(ClientIdentifier snapshot) {
        this.actor.saveSnapshot(snapshot);
    }

    void deleteSnapshots(SnapshotSelectionCriteria criteria) {
        this.actor.deleteSnapshots(criteria);
    }

    ClientActorBehavior<?> createBehavior(ClientIdentifier clientId) {
        ActorSystem system = this.actor.getContext().system();
        ClientActorContext context = new ClientActorContext(this.self(), this.persistenceId(), system, clientId, this.actor.getClientActorConfig());
        return this.actor.initialBehavior(context);
    }

    void stash() {
        this.actor.stash();
    }

    void unstash() {
        this.actor.unstashAll();
    }
}

