/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import akka.actor.ActorRef;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.opendaylight.controller.cluster.access.ABIVersion;

public class BackendInfo {
    private final ABIVersion version;
    private final ActorRef actor;
    private final int maxMessages;
    private final long sessionId;
    private final String name;

    protected BackendInfo(ActorRef actor, String name, long sessionId, ABIVersion version, int maxMessages) {
        this.version = Objects.requireNonNull(version);
        this.actor = Objects.requireNonNull(actor);
        this.name = Objects.requireNonNull(name);
        Preconditions.checkArgument((maxMessages > 0 ? 1 : 0) != 0, (String)"Maximum messages has to be positive, not %s", (int)maxMessages);
        this.maxMessages = maxMessages;
        this.sessionId = sessionId;
    }

    public final ActorRef getActor() {
        return this.actor;
    }

    public final String getName() {
        return this.name;
    }

    public final ABIVersion getVersion() {
        return this.version;
    }

    public final int getMaxMessages() {
        return this.maxMessages;
    }

    public final long getSessionId() {
        return this.sessionId;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this).omitNullValues()).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("actor", (Object)this.actor).add("sessionId", this.sessionId).add("version", (Object)this.version).add("maxMessages", this.maxMessages);
    }
}

