/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.concepts.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.controller.concepts.transform.AggregateTransformer;
import org.opendaylight.controller.concepts.transform.InputClassBasedTransformer;

public abstract class CompositeClassBasedTransformer<I, P>
implements InputClassBasedTransformer<I, I, P>,
AggregateTransformer<I, P> {
    private Map<Class<? extends I>, InputClassBasedTransformer<I, ? extends I, P>> transformers = new ConcurrentHashMap<Class<? extends I>, InputClassBasedTransformer<I, ? extends I, P>>();

    @Override
    public P transform(I input) {
        InputClassBasedTransformer<I, I, P> transformer = this.transformers.get(input.getClass());
        if (transformer == null) {
            throw new IllegalArgumentException("Transformation of: " + input + " is not supported");
        }
        return transformer.transform(input);
    }

    public void addTransformer(InputClassBasedTransformer<I, ? extends I, P> transformer) throws IllegalStateException {
        if (transformer == null) {
            throw new IllegalArgumentException("Transformer should not be null");
        }
        if (transformer.getInputClass() == null) {
            throw new IllegalArgumentException("Transformer should specify input class.");
        }
        this.transformers.put(transformer.getInputClass(), transformer);
    }

    public void removeTransformer(InputClassBasedTransformer<I, ? extends I, P> transformer) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public Collection<P> transformAll(Collection<? extends I> inputs) {
        ArrayList<P> ret = new ArrayList<P>();
        for (I i : inputs) {
            ret.add(this.transform(i));
        }
        return ret;
    }
}

