/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.concepts.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.opendaylight.controller.concepts.transform.AggregateTransformer;
import org.opendaylight.controller.concepts.transform.SimpleConditionalTransformer;

public class CompositeConditionalTransformer<I, P>
implements SimpleConditionalTransformer<I, P>,
AggregateTransformer<I, P> {
    private final Comparator<TransformerWithPriority<I, P>> comparator = new Comparator<TransformerWithPriority<I, P>>(){

        @Override
        public int compare(TransformerWithPriority<I, P> o1, TransformerWithPriority<I, P> o2) {
            return Integer.valueOf(o1.priority).compareTo(o2.priority);
        }
    };
    private final Set<TransformerWithPriority<I, P>> transformers = new TreeSet<TransformerWithPriority<I, P>>(this.comparator);

    @Override
    public boolean isAcceptable(I input) {
        for (SimpleConditionalTransformer simpleConditionalTransformer : this.transformers) {
            if (!simpleConditionalTransformer.isAcceptable(input)) continue;
            return true;
        }
        return false;
    }

    @Override
    public P transform(I input) {
        for (SimpleConditionalTransformer simpleConditionalTransformer : this.transformers) {
            if (!simpleConditionalTransformer.isAcceptable(input)) continue;
            return simpleConditionalTransformer.transform(input);
        }
        throw new IllegalStateException("Transformer for provided input is not available.");
    }

    public void addTransformer(SimpleConditionalTransformer<I, P> transformer, int priority) throws IllegalStateException {
        if (transformer == null) {
            throw new IllegalArgumentException("transformer should not be null.");
        }
        TransformerWithPriority<I, P> withPriority = new TransformerWithPriority<I, P>(transformer, priority);
        if (!this.transformers.add(withPriority)) {
            throw new IllegalStateException("transformer " + transformer + "already registered");
        }
    }

    public void removeTransformer(SimpleConditionalTransformer<I, P> transformer) throws IllegalArgumentException {
        if (transformer == null) {
            throw new IllegalArgumentException("transformer should not be null.");
        }
        if (!this.transformers.remove(transformer)) {
            throw new IllegalStateException("transformer " + transformer + "already registered");
        }
    }

    @Override
    public Collection<P> transformAll(Collection<? extends I> inputs) {
        ArrayList<P> ret = new ArrayList<P>();
        for (I i : inputs) {
            ret.add(this.transform(i));
        }
        return ret;
    }

    private static class TransformerWithPriority<I, P>
    implements SimpleConditionalTransformer<I, P> {
        final int priority;
        final SimpleConditionalTransformer<I, P> transformer;

        public TransformerWithPriority(SimpleConditionalTransformer<I, P> transformer, int priority) {
            this.priority = priority;
            this.transformer = transformer;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.transformer == null ? 0 : this.transformer.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TransformerWithPriority other = (TransformerWithPriority)obj;
            return !(this.transformer == null ? other.transformer != null : !this.transformer.equals(other.transformer));
        }

        @Override
        public boolean isAcceptable(I input) {
            return this.transformer.isAcceptable(input);
        }

        @Override
        public P transform(I input) {
            return this.transformer.transform(input);
        }
    }
}

