/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.api.jmx;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.jmx.constants.ConfigRegistryConstants;

@ThreadSafe
public class ObjectNameUtil {
    public static final String ON_DOMAIN = "org.opendaylight.controller";
    public static final String MODULE_FACTORY_NAME_KEY = "moduleFactoryName";
    public static final String SERVICE_QNAME_KEY = "serviceQName";
    public static final String INSTANCE_NAME_KEY = "instanceName";
    public static final String TYPE_KEY = "type";
    public static final String TYPE_CONFIG_TRANSACTION = "ConfigTransaction";
    public static final String TYPE_MODULE = "Module";
    public static final String TYPE_SERVICE_REFERENCE = "ServiceReference";
    public static final String TYPE_RUNTIME_BEAN = "RuntimeBean";
    public static final String TRANSACTION_NAME_KEY = "TransactionName";
    public static final String REF_NAME_KEY = "RefName";
    private static final String REPLACED_QUOTATION_MARK = "\\?";
    public static final String ON_WILDCARD = "*";
    private static Set<String> blacklist = new HashSet<String>(Arrays.asList("moduleFactoryName", "instanceName", "type"));

    public static ObjectName createON(String on) {
        try {
            return new ObjectName(on);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static ObjectName createONWithDomainAndType(String type) {
        return ConfigRegistryConstants.createONWithDomainAndType(type);
    }

    public static ObjectName createON(String name, String key, String value) {
        return ConfigRegistryConstants.createON(name, key, value);
    }

    public static ObjectName createON(String domain, Map<String, String> attribs) {
        Hashtable<String, String> table = new Hashtable<String, String>(attribs);
        try {
            return new ObjectName(domain, table);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static ObjectName createTransactionControllerON(String transactionName) {
        HashMap<String, String> onParams = new HashMap<String, String>();
        onParams.put(TRANSACTION_NAME_KEY, transactionName);
        onParams.put(TYPE_KEY, TYPE_CONFIG_TRANSACTION);
        return ObjectNameUtil.createON(ON_DOMAIN, onParams);
    }

    public static ObjectName createTransactionModuleON(String transactionName, ModuleIdentifier moduleIdentifier) {
        return ObjectNameUtil.createTransactionModuleON(transactionName, moduleIdentifier.getFactoryName(), moduleIdentifier.getInstanceName());
    }

    public static ObjectName createTransactionModuleON(String transactionName, String moduleName, String instanceName) {
        Map<String, String> onParams = ObjectNameUtil.createModuleMap(moduleName, instanceName);
        onParams.put(TRANSACTION_NAME_KEY, transactionName);
        return ObjectNameUtil.createON(ON_DOMAIN, onParams);
    }

    public static ObjectName createTransactionModuleON(String transactionName, ObjectName on) {
        return ObjectNameUtil.createTransactionModuleON(transactionName, ObjectNameUtil.getFactoryName(on), ObjectNameUtil.getInstanceName(on));
    }

    public static ObjectName createReadOnlyModuleON(ModuleIdentifier moduleIdentifier) {
        return ObjectNameUtil.createReadOnlyModuleON(moduleIdentifier.getFactoryName(), moduleIdentifier.getInstanceName());
    }

    public static ObjectName createReadOnlyServiceON(String serviceQName, String refName) {
        Map<String, String> onParams = ObjectNameUtil.createServiceMap(serviceQName, refName);
        return ObjectNameUtil.createON(ON_DOMAIN, onParams);
    }

    public static ObjectName createTransactionServiceON(String transactionName, String serviceQName, String refName) {
        Map<String, String> onParams = ObjectNameUtil.createServiceON(transactionName, serviceQName, refName);
        return ObjectNameUtil.createON(ON_DOMAIN, onParams);
    }

    public static String getServiceQName(ObjectName objectName) {
        ObjectNameUtil.checkType(objectName, TYPE_SERVICE_REFERENCE);
        String quoted = objectName.getKeyProperty(SERVICE_QNAME_KEY);
        return ObjectNameUtil.unquoteAndUnescape(objectName, quoted);
    }

    private static String unquoteAndUnescape(ObjectName objectName, String quoted) {
        if (quoted == null) {
            throw new IllegalArgumentException("Cannot find serviceQName in " + objectName);
        }
        if (!quoted.startsWith("\"") || !quoted.endsWith("\"")) {
            throw new IllegalArgumentException("Quotes not found in " + objectName);
        }
        String substring = quoted.substring(1);
        substring = substring.substring(0, substring.length() - 1);
        substring = substring.replace(REPLACED_QUOTATION_MARK, "?");
        return substring;
    }

    private static String quoteAndEscapeValue(String serviceQName) {
        return "\"" + serviceQName.replace("?", REPLACED_QUOTATION_MARK) + "\"";
    }

    public static String getReferenceName(ObjectName objectName) {
        ObjectNameUtil.checkType(objectName, TYPE_SERVICE_REFERENCE);
        return objectName.getKeyProperty(REF_NAME_KEY);
    }

    private static Map<String, String> createServiceON(String transactionName, String serviceQName, String refName) {
        HashMap<String, String> result = new HashMap<String, String>(ObjectNameUtil.createServiceMap(serviceQName, refName));
        result.put(TRANSACTION_NAME_KEY, transactionName);
        return result;
    }

    private static Map<String, String> createServiceMap(String serviceQName, String refName) {
        HashMap<String, String> onParams = new HashMap<String, String>();
        onParams.put(TYPE_KEY, TYPE_SERVICE_REFERENCE);
        onParams.put(SERVICE_QNAME_KEY, ObjectNameUtil.quoteAndEscapeValue(serviceQName));
        onParams.put(REF_NAME_KEY, refName);
        return onParams;
    }

    public static ObjectName createReadOnlyModuleON(String moduleName, String instanceName) {
        Map<String, String> onParams = ObjectNameUtil.createModuleMap(moduleName, instanceName);
        return ObjectNameUtil.createON(ON_DOMAIN, onParams);
    }

    private static Map<String, String> createModuleMap(String moduleName, String instanceName) {
        HashMap<String, String> onParams = new HashMap<String, String>();
        onParams.put(TYPE_KEY, TYPE_MODULE);
        onParams.put(MODULE_FACTORY_NAME_KEY, moduleName);
        onParams.put(INSTANCE_NAME_KEY, instanceName);
        return onParams;
    }

    public static String getFactoryName(ObjectName objectName) {
        ObjectNameUtil.checkTypeOneOf(objectName, TYPE_MODULE, TYPE_RUNTIME_BEAN);
        return objectName.getKeyProperty(MODULE_FACTORY_NAME_KEY);
    }

    public static String getInstanceName(ObjectName objectName) {
        ObjectNameUtil.checkTypeOneOf(objectName, TYPE_MODULE, TYPE_RUNTIME_BEAN);
        return objectName.getKeyProperty(INSTANCE_NAME_KEY);
    }

    public static String getTransactionName(ObjectName objectName) {
        return objectName.getKeyProperty(TRANSACTION_NAME_KEY);
    }

    public static ObjectName withoutTransactionName(ObjectName inputON) {
        HashMap<String, String> outputProperties;
        ObjectNameUtil.checkTypeOneOf(inputON, TYPE_MODULE, TYPE_SERVICE_REFERENCE);
        if (ObjectNameUtil.getTransactionName(inputON) == null) {
            throw new IllegalArgumentException("Expected ObjectName with transaction:" + inputON);
        }
        if (!ON_DOMAIN.equals(inputON.getDomain())) {
            throw new IllegalArgumentException("Expected different domain: " + inputON);
        }
        if (inputON.getKeyProperty(TYPE_KEY).equals(TYPE_MODULE)) {
            String moduleName = ObjectNameUtil.getFactoryName(inputON);
            String instanceName = ObjectNameUtil.getInstanceName(inputON);
            outputProperties = new HashMap<String, String>(ObjectNameUtil.createModuleMap(moduleName, instanceName));
        } else {
            String serviceQName = ObjectNameUtil.getServiceQName(inputON);
            String refName = ObjectNameUtil.getReferenceName(inputON);
            outputProperties = new HashMap<String, String>(ObjectNameUtil.createServiceMap(serviceQName, refName));
        }
        Map<String, String> allProperties = ObjectNameUtil.getAdditionalProperties(inputON);
        for (Map.Entry<String, String> entry : allProperties.entrySet()) {
            if (!entry.getKey().startsWith("X-")) continue;
            outputProperties.put(entry.getKey(), entry.getValue());
        }
        return ObjectNameUtil.createON(ON_DOMAIN, outputProperties);
    }

    public static ObjectName withTransactionName(ObjectName inputON, String transactionName) {
        Map<String, String> additionalProperties = ObjectNameUtil.getAdditionalProperties(inputON);
        additionalProperties.put(TRANSACTION_NAME_KEY, transactionName);
        return ObjectNameUtil.createON(inputON.getDomain(), additionalProperties);
    }

    private static void assertDoesNotContain(Map<String, String> additionalProperties, String key) {
        if (additionalProperties.containsKey(key)) {
            throw new IllegalArgumentException("Map 'additionalProperties' cannot overwrite attribute " + key);
        }
    }

    public static ObjectName createRuntimeBeanName(String moduleName, String instanceName, Map<String, String> additionalProperties) {
        ObjectNameUtil.assertDoesNotContain(additionalProperties, MODULE_FACTORY_NAME_KEY);
        ObjectNameUtil.assertDoesNotContain(additionalProperties, INSTANCE_NAME_KEY);
        ObjectNameUtil.assertDoesNotContain(additionalProperties, TYPE_KEY);
        ObjectNameUtil.assertDoesNotContain(additionalProperties, TRANSACTION_NAME_KEY);
        HashMap<String, String> map = new HashMap<String, String>(additionalProperties);
        map.put(MODULE_FACTORY_NAME_KEY, moduleName);
        map.put(INSTANCE_NAME_KEY, instanceName);
        map.put(TYPE_KEY, TYPE_RUNTIME_BEAN);
        return ObjectNameUtil.createON(ON_DOMAIN, map);
    }

    public static Map<String, String> getAdditionalPropertiesOfRuntimeBeanName(ObjectName on) {
        ObjectNameUtil.checkType(on, TYPE_RUNTIME_BEAN);
        Map<String, String> allProperties = ObjectNameUtil.getAdditionalProperties(on);
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : allProperties.entrySet()) {
            if (blacklist.contains(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static Map<String, String> getAdditionalProperties(ObjectName on) {
        Hashtable<String, String> keyPropertyList = on.getKeyPropertyList();
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : keyPropertyList.entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static void checkDomain(ObjectName objectName) {
        if (!ON_DOMAIN.equals(objectName.getDomain())) {
            throw new IllegalArgumentException("Wrong domain " + objectName);
        }
    }

    public static void checkType(ObjectName objectName, String type) {
        if (!type.equals(objectName.getKeyProperty(TYPE_KEY))) {
            throw new IllegalArgumentException("Wrong type, expected '" + type + "', got " + objectName);
        }
    }

    public static void checkTypeOneOf(ObjectName objectName, String ... types) {
        for (String type : types) {
            if (!type.equals(objectName.getKeyProperty(TYPE_KEY))) continue;
            return;
        }
        throw new IllegalArgumentException("Wrong type, expected one of " + Arrays.asList(types) + ", got " + objectName);
    }

    public static ObjectName createModulePattern(String moduleName, String instanceName) {
        moduleName = moduleName == null ? ON_WILDCARD : moduleName;
        instanceName = instanceName == null ? ON_WILDCARD : instanceName;
        ObjectName namePattern = ObjectNameUtil.createON("org.opendaylight.controller:type=Module,moduleFactoryName=" + moduleName + "," + "" + INSTANCE_NAME_KEY + "=" + instanceName);
        return namePattern;
    }

    public static ObjectName createModulePattern(String ifcName, String instanceName, String transactionName) {
        ifcName = ifcName == null ? ON_WILDCARD : ifcName;
        instanceName = instanceName == null ? ON_WILDCARD : instanceName;
        transactionName = transactionName == null ? ON_WILDCARD : transactionName;
        return ObjectNameUtil.createON("org.opendaylight.controller:type=Module,moduleFactoryName=" + ifcName + "," + INSTANCE_NAME_KEY + "=" + instanceName + "," + TRANSACTION_NAME_KEY + "=" + transactionName);
    }

    public static ObjectName createRuntimeBeanPattern(String moduleName, String instanceName) {
        moduleName = moduleName == null ? ON_WILDCARD : moduleName;
        instanceName = instanceName == null ? ON_WILDCARD : instanceName;
        return ObjectNameUtil.createON("org.opendaylight.controller:type=RuntimeBean,moduleFactoryName=" + moduleName + "," + INSTANCE_NAME_KEY + "=" + instanceName + ",*");
    }

    public static ModuleIdentifier fromON(ObjectName objectName, String expectedType) {
        ObjectNameUtil.checkType(objectName, expectedType);
        String factoryName = ObjectNameUtil.getFactoryName(objectName);
        if (factoryName == null) {
            throw new IllegalArgumentException("ObjectName does not contain module name");
        }
        String instanceName = ObjectNameUtil.getInstanceName(objectName);
        if (instanceName == null) {
            throw new IllegalArgumentException("ObjectName does not contain instance name");
        }
        return new ModuleIdentifier(factoryName, instanceName);
    }

    public static boolean isServiceReference(ObjectName objectName) {
        return TYPE_SERVICE_REFERENCE.equals(objectName.getKeyProperty(TYPE_KEY));
    }
}

