/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.modules;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.ModuleType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.modules.Module;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.modules.ModuleKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.modules.module.Configuration;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.modules.module.State;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ModuleBuilder {
    private Configuration _configuration;
    private ModuleKey _key;
    private String _name;
    private State _state;
    private Class<? extends ModuleType> _type;
    Map<Class<? extends Augmentation<Module>>, Augmentation<Module>> augmentation = new HashMap<Class<? extends Augmentation<Module>>, Augmentation<Module>>();

    public ModuleBuilder() {
    }

    public ModuleBuilder(Module base) {
        if (base.getKey() == null) {
            this._key = new ModuleKey(base.getName(), base.getType());
            this._name = base.getName();
            this._type = base.getType();
        } else {
            this._key = base.getKey();
            this._name = this._key.getName();
            this._type = this._key.getType();
        }
        this._configuration = base.getConfiguration();
        this._state = base.getState();
        if (base instanceof ModuleImpl) {
            ModuleImpl _impl = (ModuleImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<Module>>, Augmentation<Module>>(_impl.augmentation);
        }
    }

    public Configuration getConfiguration() {
        return this._configuration;
    }

    public ModuleKey getKey() {
        return this._key;
    }

    public String getName() {
        return this._name;
    }

    public State getState() {
        return this._state;
    }

    public Class<? extends ModuleType> getType() {
        return this._type;
    }

    public <E extends Augmentation<Module>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ModuleBuilder setConfiguration(Configuration value) {
        this._configuration = value;
        return this;
    }

    public ModuleBuilder setKey(ModuleKey value) {
        this._key = value;
        return this;
    }

    public ModuleBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public ModuleBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public ModuleBuilder setType(Class<? extends ModuleType> value) {
        this._type = value;
        return this;
    }

    public ModuleBuilder addAugmentation(Class<? extends Augmentation<Module>> augmentationType, Augmentation<Module> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Module build() {
        return new ModuleImpl(this);
    }

    private static final class ModuleImpl
    implements Module {
        private final Configuration _configuration;
        private final ModuleKey _key;
        private final String _name;
        private final State _state;
        private final Class<? extends ModuleType> _type;
        private Map<Class<? extends Augmentation<Module>>, Augmentation<Module>> augmentation = new HashMap<Class<? extends Augmentation<Module>>, Augmentation<Module>>();

        public Class<Module> getImplementedInterface() {
            return Module.class;
        }

        private ModuleImpl(ModuleBuilder base) {
            if (base.getKey() == null) {
                this._key = new ModuleKey(base.getName(), base.getType());
                this._name = base.getName();
                this._type = base.getType();
            } else {
                this._key = base.getKey();
                this._name = this._key.getName();
                this._type = this._key.getType();
            }
            this._configuration = base.getConfiguration();
            this._state = base.getState();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Module>>, Augmentation<Module>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Module>>, Augmentation<Module>>(base.augmentation);
                }
            }
        }

        @Override
        public Configuration getConfiguration() {
            return this._configuration;
        }

        @Override
        public ModuleKey getKey() {
            return this._key;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public State getState() {
            return this._state;
        }

        @Override
        public Class<? extends ModuleType> getType() {
            return this._type;
        }

        public <E extends Augmentation<Module>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._configuration == null ? 0 : this._configuration.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
            result = 31 * result + (this._state == null ? 0 : this._state.hashCode());
            result = 31 * result + (this._type == null ? 0 : this._type.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Module.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Module other = (Module)obj;
            if (this._configuration == null ? other.getConfiguration() != null : !this._configuration.equals(other.getConfiguration())) {
                return false;
            }
            if (this._key == null ? other.getKey() != null : !this._key.equals(other.getKey())) {
                return false;
            }
            if (this._name == null ? other.getName() != null : !this._name.equals(other.getName())) {
                return false;
            }
            if (this._state == null ? other.getState() != null : !this._state.equals(other.getState())) {
                return false;
            }
            if (this._type == null ? other.getType() != null : !this._type.equals(other.getType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ModuleImpl otherImpl = (ModuleImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Module>>, Augmentation<Module>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Module [");
            boolean first = true;
            if (this._configuration != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_configuration=");
                builder.append(this._configuration);
            }
            if (this._key != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_key=");
                builder.append(this._key);
            }
            if (this._name != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_name=");
                builder.append(this._name);
            }
            if (this._state != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_state=");
                builder.append(this._state);
            }
            if (this._type != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_type=");
                builder.append(this._type);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

