/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.services;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.ServiceType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.services.Service;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.services.ServiceKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.services.service.Instance;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ServiceBuilder {
    private List<Instance> _instance;
    private ServiceKey _key;
    private Class<? extends ServiceType> _type;
    Map<Class<? extends Augmentation<Service>>, Augmentation<Service>> augmentation = new HashMap<Class<? extends Augmentation<Service>>, Augmentation<Service>>();

    public ServiceBuilder() {
    }

    public ServiceBuilder(Service base) {
        if (base.getKey() == null) {
            this._key = new ServiceKey(base.getType());
            this._type = base.getType();
        } else {
            this._key = base.getKey();
            this._type = this._key.getType();
        }
        this._instance = base.getInstance();
        if (base instanceof ServiceImpl) {
            ServiceImpl _impl = (ServiceImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<Service>>, Augmentation<Service>>(_impl.augmentation);
        }
    }

    public List<Instance> getInstance() {
        return this._instance;
    }

    public ServiceKey getKey() {
        return this._key;
    }

    public Class<? extends ServiceType> getType() {
        return this._type;
    }

    public <E extends Augmentation<Service>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ServiceBuilder setInstance(List<Instance> value) {
        this._instance = value;
        return this;
    }

    public ServiceBuilder setKey(ServiceKey value) {
        this._key = value;
        return this;
    }

    public ServiceBuilder setType(Class<? extends ServiceType> value) {
        this._type = value;
        return this;
    }

    public ServiceBuilder addAugmentation(Class<? extends Augmentation<Service>> augmentationType, Augmentation<Service> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Service build() {
        return new ServiceImpl(this);
    }

    private static final class ServiceImpl
    implements Service {
        private final List<Instance> _instance;
        private final ServiceKey _key;
        private final Class<? extends ServiceType> _type;
        private Map<Class<? extends Augmentation<Service>>, Augmentation<Service>> augmentation = new HashMap<Class<? extends Augmentation<Service>>, Augmentation<Service>>();

        public Class<Service> getImplementedInterface() {
            return Service.class;
        }

        private ServiceImpl(ServiceBuilder base) {
            if (base.getKey() == null) {
                this._key = new ServiceKey(base.getType());
                this._type = base.getType();
            } else {
                this._key = base.getKey();
                this._type = this._key.getType();
            }
            this._instance = base.getInstance();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Service>>, Augmentation<Service>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Service>>, Augmentation<Service>>(base.augmentation);
                }
            }
        }

        @Override
        public List<Instance> getInstance() {
            return this._instance;
        }

        @Override
        public ServiceKey getKey() {
            return this._key;
        }

        @Override
        public Class<? extends ServiceType> getType() {
            return this._type;
        }

        public <E extends Augmentation<Service>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._instance == null ? 0 : this._instance.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this._type == null ? 0 : this._type.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Service.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Service other = (Service)obj;
            if (this._instance == null ? other.getInstance() != null : !this._instance.equals(other.getInstance())) {
                return false;
            }
            if (this._key == null ? other.getKey() != null : !this._key.equals(other.getKey())) {
                return false;
            }
            if (this._type == null ? other.getType() != null : !this._type.equals(other.getType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ServiceImpl otherImpl = (ServiceImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Service>>, Augmentation<Service>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Service [");
            boolean first = true;
            if (this._instance != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_instance=");
                builder.append(this._instance);
            }
            if (this._key != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_key=");
                builder.append(this._key);
            }
            if (this._type != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_type=");
                builder.append(this._type);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

