/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.services.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.services.service.Instance;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.services.service.InstanceKey;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class InstanceBuilder {
    private InstanceKey _key;
    private String _name;
    private String _provider;
    Map<Class<? extends Augmentation<Instance>>, Augmentation<Instance>> augmentation = new HashMap<Class<? extends Augmentation<Instance>>, Augmentation<Instance>>();

    public InstanceBuilder() {
    }

    public InstanceBuilder(Instance base) {
        if (base.getKey() == null) {
            this._key = new InstanceKey(base.getName());
            this._name = base.getName();
        } else {
            this._key = base.getKey();
            this._name = this._key.getName();
        }
        this._provider = base.getProvider();
        if (base instanceof InstanceImpl) {
            InstanceImpl _impl = (InstanceImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<Instance>>, Augmentation<Instance>>(_impl.augmentation);
        }
    }

    public InstanceKey getKey() {
        return this._key;
    }

    public String getName() {
        return this._name;
    }

    public String getProvider() {
        return this._provider;
    }

    public <E extends Augmentation<Instance>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public InstanceBuilder setKey(InstanceKey value) {
        this._key = value;
        return this;
    }

    public InstanceBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public InstanceBuilder setProvider(String value) {
        this._provider = value;
        return this;
    }

    public InstanceBuilder addAugmentation(Class<? extends Augmentation<Instance>> augmentationType, Augmentation<Instance> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Instance build() {
        return new InstanceImpl(this);
    }

    private static final class InstanceImpl
    implements Instance {
        private final InstanceKey _key;
        private final String _name;
        private final String _provider;
        private Map<Class<? extends Augmentation<Instance>>, Augmentation<Instance>> augmentation = new HashMap<Class<? extends Augmentation<Instance>>, Augmentation<Instance>>();

        public Class<Instance> getImplementedInterface() {
            return Instance.class;
        }

        private InstanceImpl(InstanceBuilder base) {
            if (base.getKey() == null) {
                this._key = new InstanceKey(base.getName());
                this._name = base.getName();
            } else {
                this._key = base.getKey();
                this._name = this._key.getName();
            }
            this._provider = base.getProvider();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Instance>>, Augmentation<Instance>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Instance>>, Augmentation<Instance>>(base.augmentation);
                }
            }
        }

        @Override
        public InstanceKey getKey() {
            return this._key;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public String getProvider() {
            return this._provider;
        }

        public <E extends Augmentation<Instance>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
            result = 31 * result + (this._provider == null ? 0 : this._provider.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Instance.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Instance other = (Instance)obj;
            if (this._key == null ? other.getKey() != null : !this._key.equals(other.getKey())) {
                return false;
            }
            if (this._name == null ? other.getName() != null : !this._name.equals(other.getName())) {
                return false;
            }
            if (this._provider == null ? other.getProvider() != null : !this._provider.equals(other.getProvider())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                InstanceImpl otherImpl = (InstanceImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Instance>>, Augmentation<Instance>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Instance [");
            boolean first = true;
            if (this._key != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_key=");
                builder.append(this._key);
            }
            if (this._name != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_name=");
                builder.append(this._name);
            }
            if (this._provider != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_provider=");
                builder.append(this._provider);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

