/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.DependencyResolverFactory;
import org.opendaylight.controller.config.api.DynamicMBeanWithInstance;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.AbstractServiceInterface;
import org.opendaylight.controller.config.manager.impl.util.InterfacesHelper;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.osgi.framework.BundleContext;

public class ClassBasedModuleFactory
implements ModuleFactory {
    private final String implementationName;
    private final Class<? extends Module> configBeanClass;

    public ClassBasedModuleFactory(String implementationName, Class<? extends Module> configBeanClass) {
        this.implementationName = implementationName;
        this.configBeanClass = configBeanClass;
    }

    public String getImplementationName() {
        return this.implementationName;
    }

    public Module createModule(String instanceName, DependencyResolver dependencyResolver, DynamicMBeanWithInstance old, BundleContext bundleContext) throws Exception {
        Preconditions.checkNotNull((Object)old);
        return this.constructModule(instanceName, dependencyResolver, old);
    }

    private Module constructModule(String instanceName, DependencyResolver dependencyResolver, DynamicMBeanWithInstance old) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<? extends Module> declaredConstructor;
        Preconditions.checkNotNull((Object)dependencyResolver);
        ModuleIdentifier moduleIdentifier = new ModuleIdentifier(this.implementationName, instanceName);
        try {
            declaredConstructor = this.configBeanClass.getDeclaredConstructor(DynamicMBeanWithInstance.class, ModuleIdentifier.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Did not find constructor with parameters (DynamicMBeanWithInstance) in " + this.configBeanClass, e);
        }
        Preconditions.checkState((declaredConstructor != null ? 1 : 0) != 0);
        return declaredConstructor.newInstance(old, moduleIdentifier);
    }

    public Module createModule(String instanceName, DependencyResolver dependencyResolver, BundleContext bundleContext) {
        try {
            return this.constructModule(instanceName, dependencyResolver, null);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isModuleImplementingServiceInterface(Class<? extends AbstractServiceInterface> serviceInterface) {
        Class<?>[] classes = this.configBeanClass.getInterfaces();
        List<Class<?>> ifc = Arrays.asList(classes);
        if (ifc.contains(serviceInterface)) {
            return true;
        }
        for (Class<?> c : classes) {
            ifc = Arrays.asList(c.getInterfaces());
            if (!ifc.contains(serviceInterface)) continue;
            return true;
        }
        return false;
    }

    public Set<Module> getDefaultModules(DependencyResolverFactory dependencyResolverFactory, BundleContext bundleContext) {
        return new HashSet<Module>();
    }

    public Set<Class<? extends AbstractServiceInterface>> getImplementedServiceIntefaces() {
        return InterfacesHelper.getAllAbstractServiceClasses(this.configBeanClass);
    }
}

