/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl;

import com.google.common.collect.Sets;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.config.api.runtime.RuntimeBean;
import org.opendaylight.controller.config.manager.impl.AbstractLockedPlatformMBeanServerTest;
import org.opendaylight.controller.config.manager.impl.ConfigRegistryImpl;
import org.opendaylight.controller.config.manager.impl.jmx.BaseJMXRegistrator;
import org.opendaylight.controller.config.manager.impl.jmx.RootRuntimeBeanRegistratorImpl;
import org.opendaylight.controller.config.manager.impl.runtimembean.TestingRuntimeBean;

public class ConfigRegistryImplLookupTest
extends AbstractLockedPlatformMBeanServerTest {
    private ConfigRegistryImpl configRegistryImpl;
    private BaseJMXRegistrator baseJMXRegistrator;
    private static final String moduleNameA = "moduleA";
    private static final String moduleNameB = "moduleB";
    private static final String instanceNameA = "instA";
    private static final String instanceNameB = "instB";
    private static final String instanceNameC = "instC";
    private static final ObjectName name1 = ObjectNameUtil.createReadOnlyModuleON((String)"moduleA", (String)"instA");
    private static final ObjectName name2 = ObjectNameUtil.createReadOnlyModuleON((String)"moduleA", (String)"instB");
    private static final ObjectName name3 = ObjectNameUtil.createReadOnlyModuleON((String)"moduleA", (String)"instC");
    private static final ObjectName name4 = ObjectNameUtil.createReadOnlyModuleON((String)"moduleB", (String)"instA");
    private static final ObjectName name5 = ObjectNameUtil.createRuntimeBeanName((String)"moduleA", (String)"instA", Collections.emptyMap());
    private static final ObjectName name6 = ObjectNameUtil.createRuntimeBeanName((String)"moduleA", (String)"instB", Collections.emptyMap());
    private static final ObjectName name8 = ObjectNameUtil.createRuntimeBeanName((String)"moduleB", (String)"instA", Collections.emptyMap());
    private static final ObjectName name9 = ObjectNameUtil.createTransactionModuleON((String)"transaction", (String)"moduleA", (String)"instA");

    @Before
    public void setUp() throws Exception {
        this.configRegistryImpl = new ConfigRegistryImpl(null, ManagementFactory.getPlatformMBeanServer(), null);
        Field field = this.configRegistryImpl.getClass().getDeclaredField("baseJMXRegistrator");
        field.setAccessible(true);
        this.baseJMXRegistrator = (BaseJMXRegistrator)field.get(this.configRegistryImpl);
        this.registerModuleBean(new TestingRuntimeBean(), this.baseJMXRegistrator, name1);
        this.registerModuleBean(new TestingRuntimeBean(), this.baseJMXRegistrator, name2);
        this.registerModuleBean(new TestingRuntimeBean(), this.baseJMXRegistrator, name3);
        this.registerModuleBean(new TestingRuntimeBean(), this.baseJMXRegistrator, name4);
        this.registerRuntimeBean(new TestingRuntimeBean(), this.baseJMXRegistrator, name5);
        this.registerRuntimeBean(new TestingRuntimeBean(), this.baseJMXRegistrator, name6);
        this.registerRuntimeBean(new TestingRuntimeBean(), this.baseJMXRegistrator, name8);
        this.baseJMXRegistrator.createTransactionJMXRegistrator("transaction").createTransactionModuleJMXRegistrator().registerMBean((Object)new TestingRuntimeBean(), name9);
    }

    private void registerModuleBean(TestingRuntimeBean testingRuntimeBean, BaseJMXRegistrator baseJMXRegistrator, ObjectName objectName) throws InstanceAlreadyExistsException {
        baseJMXRegistrator.createModuleJMXRegistrator().registerMBean((Object)testingRuntimeBean, objectName);
    }

    private void registerRuntimeBean(RuntimeBean object, BaseJMXRegistrator baseJMXRegistrator, ObjectName runtimeON) throws InstanceAlreadyExistsException {
        String factoryName = ObjectNameUtil.getFactoryName((ObjectName)runtimeON);
        String instanceName = ObjectNameUtil.getInstanceName((ObjectName)runtimeON);
        Map properties = ObjectNameUtil.getAdditionalPropertiesOfRuntimeBeanName((ObjectName)runtimeON);
        RootRuntimeBeanRegistratorImpl runtimeBeanRegistrator = baseJMXRegistrator.createRuntimeBeanRegistrator(new ModuleIdentifier(factoryName, instanceName));
        Assert.assertThat((Object)properties.isEmpty(), (Matcher)Is.is((Object)true));
        runtimeBeanRegistrator.registerRoot(object);
    }

    @After
    public void cleanUp() {
        this.baseJMXRegistrator.close();
    }

    @Test
    public void testLookupConfigBeans() throws Exception {
        Set beans = this.configRegistryImpl.lookupConfigBeans();
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new ObjectName[]{name1, name2, name3, name4}), (Object)beans);
        beans = this.configRegistryImpl.lookupConfigBeans();
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new ObjectName[]{name1, name2, name3, name4}), (Object)beans);
    }

    @Test
    public void testLookupConfigBeanWithModuleName() throws Exception {
        Set bean = this.configRegistryImpl.lookupConfigBeans(moduleNameA);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new ObjectName[]{name1, name2, name3}), (Object)bean);
    }

    @Test
    public void testLookupConfigBeanWithModuleNameAndInstanceName() throws Exception {
        Set bean = this.configRegistryImpl.lookupConfigBeans(moduleNameA, instanceNameA);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new ObjectName[]{name1}), (Object)bean);
    }

    @Test
    public void testLookupRuntimeBeans() throws Exception {
        Set beans = this.configRegistryImpl.lookupRuntimeBeans();
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new ObjectName[]{name5, name6, name8}), (Object)beans);
        beans = this.configRegistryImpl.lookupRuntimeBeans(null, null);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new ObjectName[]{name5, name6, name8}), (Object)beans);
    }

    @Test
    public void testLookupRuntimeBeansWithIFcNameAndImplName() throws Exception {
        Set beans = this.configRegistryImpl.lookupRuntimeBeans(moduleNameA, instanceNameA);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new ObjectName[]{name5}), (Object)beans);
    }
}

