/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMX;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.config.api.jmx.ServiceReferenceMXBean;
import org.opendaylight.controller.config.manager.impl.AbstractConfigTest;
import org.opendaylight.controller.config.manager.impl.factoriesresolver.HardcodedModuleFactoriesResolver;
import org.opendaylight.controller.config.manager.testingservices.parallelapsp.TestingParallelAPSPModuleFactory;
import org.opendaylight.controller.config.manager.testingservices.parallelapsp.test.AbstractParallelAPSPTest;
import org.opendaylight.controller.config.manager.testingservices.scheduledthreadpool.TestingScheduledThreadPoolModuleFactory;
import org.opendaylight.controller.config.manager.testingservices.threadpool.TestingFixedThreadPoolModuleFactory;
import org.opendaylight.controller.config.manager.testingservices.threadpool.TestingThreadPoolIfc;
import org.opendaylight.controller.config.util.ConfigTransactionJMXClient;

public class ServiceReferenceRegistryImplTest
extends AbstractParallelAPSPTest {
    @Before
    public void setUp() {
        super.initConfigTransactionManagerImpl(new HardcodedModuleFactoriesResolver(this.mockedContext, new TestingFixedThreadPoolModuleFactory(), new TestingParallelAPSPModuleFactory(), new TestingScheduledThreadPoolModuleFactory()));
    }

    @Override
    protected String getThreadPoolImplementationName() {
        return "fixed";
    }

    @Test
    public void test() throws Exception {
        ConfigTransactionJMXClient transaction1 = this.configRegistryClient.createTransaction();
        int fixedNrOfThreads = 20;
        int scheduledNrOfThreads = 30;
        ObjectName fixedTPTransactionON = transaction1.createModule(this.getThreadPoolImplementationName(), "fixed1");
        platformMBeanServer.setAttribute(fixedTPTransactionON, new Attribute("ThreadCount", fixedNrOfThreads));
        ObjectName scheduledTPTransactionON = transaction1.createModule("scheduled", "scheduled1");
        platformMBeanServer.setAttribute(scheduledTPTransactionON, new Attribute("ThreadCount", scheduledNrOfThreads));
        String refName = "ref";
        ObjectName serviceReference = transaction1.saveServiceReference("(ns?revision=foo)testing-threadpool", refName, fixedTPTransactionON);
        this.createParallelAPSP(transaction1, serviceReference);
        transaction1.commit();
        ServiceReferenceMXBean serviceReferenceMXBean = JMX.newMXBeanProxy(platformMBeanServer, ObjectNameUtil.withoutTransactionName((ObjectName)serviceReference), ServiceReferenceMXBean.class);
        Assert.assertEquals((Object)ObjectNameUtil.withoutTransactionName((ObjectName)fixedTPTransactionON), (Object)serviceReferenceMXBean.getCurrentImplementation());
        this.checkApspThreadCount(fixedNrOfThreads);
        List<AbstractConfigTest.RecordingBundleContextServiceRegistrationHandler.RegistrationHolder> registrations = ((AbstractConfigTest.RecordingBundleContextServiceRegistrationHandler)this.currentBundleContextServiceRegistrationHandler).getRegistrations();
        Assert.assertEquals((long)1L, (long)registrations.size());
        AbstractConfigTest.RecordingBundleContextServiceRegistrationHandler.RegistrationHolder record = registrations.get(0);
        Assert.assertEquals(TestingThreadPoolIfc.class, record.clazz);
        Assert.assertEquals((Object)ImmutableMap.of((Object)"name", (Object)"ref"), (Object)((Map)((Object)record.props)));
        ConfigTransactionJMXClient transaction2 = this.configRegistryClient.createTransaction();
        transaction2.saveServiceReference("(ns?revision=foo)testing-threadpool", refName, ObjectNameUtil.withTransactionName((ObjectName)scheduledTPTransactionON, (String)transaction2.getTransactionName()));
        transaction2.commit();
        this.checkApspThreadCount(scheduledNrOfThreads);
        Assert.assertEquals((Object)ObjectNameUtil.withoutTransactionName((ObjectName)scheduledTPTransactionON), (Object)serviceReferenceMXBean.getCurrentImplementation());
        this.configRegistryClient.createTransaction().commit();
        Map serviceMapping = this.configRegistryClient.getServiceMapping();
        ImmutableMap expectedMapping = ImmutableMap.of((Object)"(ns?revision=foo)testing-threadpool", (Object)ImmutableMap.of((Object)refName, (Object)ObjectNameUtil.withoutTransactionName((ObjectName)scheduledTPTransactionON)));
        Assert.assertEquals((Object)expectedMapping, (Object)serviceMapping);
        ConfigTransactionJMXClient transaction4 = this.configRegistryClient.createTransaction();
        Set objectNames = transaction4.lookupConfigBeans();
        for (ObjectName on : objectNames) {
            transaction4.destroyModule(on);
        }
        transaction4.commit();
        serviceMapping = this.configRegistryClient.getServiceMapping();
        Assert.assertTrue((boolean)serviceMapping.isEmpty());
    }

    private void checkApspThreadCount(int fixedNrOfThreads) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        ObjectName apspON = ObjectNameUtil.createReadOnlyModuleON((String)"parallel", (String)"apsp-parallel");
        Assert.assertEquals((Object)fixedNrOfThreads, (Object)platformMBeanServer.getAttribute(apspON, "MaxNumberOfThreads"));
    }
}

