/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.dependencyresolver;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.ServiceReferenceReadableRegistry;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.config.manager.impl.AbstractLockedPlatformMBeanServerTest;
import org.opendaylight.controller.config.manager.impl.ModuleInternalInfo;
import org.opendaylight.controller.config.manager.impl.TransactionIdentifier;
import org.opendaylight.controller.config.manager.impl.TransactionStatus;
import org.opendaylight.controller.config.manager.impl.dependencyresolver.DependencyResolverImpl;
import org.opendaylight.controller.config.manager.impl.dependencyresolver.DependencyResolverManager;
import org.opendaylight.controller.config.manager.impl.jmx.TransactionModuleJMXRegistrator;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.osgi.framework.BundleContext;

public class DependencyResolverManagerTest
extends AbstractLockedPlatformMBeanServerTest {
    final ModuleIdentifier apspName = new ModuleIdentifier("apsp", "apsp");
    final ModuleIdentifier threadPoolName = new ModuleIdentifier("threadpool", "threadpool");
    final ModuleIdentifier threadFactoryName = new ModuleIdentifier("threadfactory", "threadfactory");
    private DependencyResolverManager tested;
    TransactionStatus transactionStatus;

    @Before
    public void setUp() {
        this.transactionStatus = (TransactionStatus)Mockito.mock(TransactionStatus.class);
        ServiceReferenceReadableRegistry mockedRegistry = (ServiceReferenceReadableRegistry)Mockito.mock(ServiceReferenceReadableRegistry.class);
        this.tested = new DependencyResolverManager(new TransactionIdentifier("txName"), this.transactionStatus, mockedRegistry, null, platformMBeanServer);
        ((TransactionStatus)Mockito.doNothing().when((Object)this.transactionStatus)).checkCommitStarted();
        ((TransactionStatus)Mockito.doNothing().when((Object)this.transactionStatus)).checkNotCommitted();
    }

    @Test
    public void testOrdering() {
        DependencyResolverImpl apspDRI = this.tested.getOrCreate(this.apspName);
        DependencyResolverManagerTest.mockGetInstance(this.tested, this.apspName);
        DependencyResolverImpl threadPoolDRI = this.tested.getOrCreate(this.threadPoolName);
        DependencyResolverManagerTest.mockGetInstance(this.tested, this.threadPoolName);
        this.tested.getOrCreate(this.threadFactoryName);
        DependencyResolverManagerTest.mockGetInstance(this.tested, this.threadFactoryName);
        this.declareDependency(threadPoolDRI, this.threadFactoryName);
        this.declareDependency(apspDRI, this.threadPoolName);
        Mockito.reset((Object[])new TransactionStatus[]{this.transactionStatus});
        ((TransactionStatus)Mockito.doNothing().when((Object)this.transactionStatus)).checkCommitStarted();
        ((TransactionStatus)Mockito.doNothing().when((Object)this.transactionStatus)).checkCommitted();
        ((TransactionStatus)Mockito.doNothing().when((Object)this.transactionStatus)).checkNotCommitted();
        List sortedModuleIdentifiers = this.tested.getSortedModuleIdentifiers();
        Assert.assertEquals(Arrays.asList(this.threadFactoryName, this.threadPoolName, this.apspName), (Object)sortedModuleIdentifiers);
    }

    private void declareDependency(DependencyResolverImpl dependerResolver, ModuleIdentifier dependentName) {
        JmxAttribute dummyAttribute = new JmxAttribute("dummy");
        dependerResolver.resolveInstance(Object.class, ObjectNameUtil.createReadOnlyModuleON((ModuleIdentifier)dependentName), dummyAttribute);
    }

    private static void mockGetInstance(DependencyResolverManager tested, ModuleIdentifier moduleIdentifier) {
        ModuleFactory moduleFactory = (ModuleFactory)Mockito.mock(ModuleFactory.class);
        ModuleInternalInfo maybeOldInternalInfo = null;
        TransactionModuleJMXRegistrator.TransactionModuleJMXRegistration transactionModuleJMXRegistration = null;
        boolean isDefaultBean = false;
        tested.put(moduleIdentifier, DependencyResolverManagerTest.mockedModule(), moduleFactory, maybeOldInternalInfo, transactionModuleJMXRegistration, isDefaultBean, (BundleContext)Mockito.mock(BundleContext.class));
    }

    private static Module mockedModule() {
        Module mockedModule = (Module)Mockito.mock(Module.class);
        ((Module)Mockito.doReturn((Object)Mockito.mock(AutoCloseable.class)).when((Object)mockedModule)).getInstance();
        ((Module)Mockito.doReturn((Object)new ModuleIdentifier("fact", "instance")).when((Object)mockedModule)).getIdentifier();
        return mockedModule;
    }
}

