/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.dynamicmbean;

import java.lang.management.ManagementFactory;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.DynamicMBean;
import javax.management.JMX;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.config.manager.impl.AbstractLockedPlatformMBeanServerTest;
import org.opendaylight.controller.config.manager.impl.dynamicmbean.AbstractDynamicWrapper;
import org.opendaylight.controller.config.manager.testingservices.threadpool.TestingFixedThreadPool;
import org.opendaylight.controller.config.manager.testingservices.threadpool.TestingFixedThreadPoolConfigMXBean;
import org.opendaylight.controller.config.manager.testingservices.threadpool.TestingFixedThreadPoolModule;
import org.opendaylight.controller.config.manager.testingservices.threadpool.TestingFixedThreadPoolModuleFactory;
import org.opendaylight.controller.config.spi.Module;

public abstract class AbstractDynamicWrapperTest
extends AbstractLockedPlatformMBeanServerTest {
    protected final MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
    private static final String moduleName = "impl";
    protected final ObjectName threadPoolDynamicWrapperON = ObjectNameUtil.createReadOnlyModuleON((String)"impl", (String)"fixed1");
    protected static final String THREAD_COUNT = "ThreadCount";
    protected static final String TRIGGER_NEW_INSTANCE_CREATION = "TriggerNewInstanceCreation";
    protected final int threadCount = 5;
    protected TestingFixedThreadPoolModule threadPoolConfigBean;
    private static final ModuleIdentifier moduleIdentifier = new ModuleIdentifier("impl", "clientname2");
    protected MBeanServer internalServer;

    @Before
    public void registerToJMX() throws Exception {
        this.internalServer = MBeanServerFactory.createMBeanServer();
        TestingFixedThreadPoolModuleFactory testingFixedThreadPoolConfigBeanFactory = new TestingFixedThreadPoolModuleFactory();
        this.threadPoolConfigBean = testingFixedThreadPoolConfigBeanFactory.createModule("", null, null);
        this.threadPoolConfigBean.setThreadCount(5);
        AbstractDynamicWrapper dynamicWrapper = this.getDynamicWrapper(this.threadPoolConfigBean, moduleIdentifier);
        this.platformMBeanServer.registerMBean(dynamicWrapper, this.threadPoolDynamicWrapperON);
    }

    @After
    public void unregisterFromJMX() throws Exception {
        TestingFixedThreadPool.cleanUp();
        this.platformMBeanServer.unregisterMBean(this.threadPoolDynamicWrapperON);
        MBeanServerFactory.releaseMBeanServer(this.internalServer);
    }

    protected abstract AbstractDynamicWrapper getDynamicWrapper(Module var1, ModuleIdentifier var2);

    @Test
    public void testReadAttributes() throws Exception {
        DynamicMBean proxy = JMX.newMBeanProxy(this.platformMBeanServer, this.threadPoolDynamicWrapperON, DynamicMBean.class);
        Assert.assertEquals((Object)5, (Object)proxy.getAttribute(THREAD_COUNT));
        Assert.assertEquals((Object)this.threadPoolConfigBean.isTriggerNewInstanceCreation(), (Object)proxy.getAttribute(TRIGGER_NEW_INSTANCE_CREATION));
        AttributeList attributes = proxy.getAttributes(new String[]{THREAD_COUNT, TRIGGER_NEW_INSTANCE_CREATION});
        Assert.assertEquals((long)2L, (long)attributes.size());
        Attribute threadCountAttr = (Attribute)attributes.get(0);
        Assert.assertEquals((Object)THREAD_COUNT, (Object)threadCountAttr.getName());
        Assert.assertEquals((Object)5, (Object)threadCountAttr.getValue());
        Attribute boolTestAttr = (Attribute)attributes.get(1);
        Assert.assertEquals((Object)TRIGGER_NEW_INSTANCE_CREATION, (Object)boolTestAttr.getName());
        Assert.assertEquals((Object)this.threadPoolConfigBean.isTriggerNewInstanceCreation(), (Object)boolTestAttr.getValue());
        MBeanInfo mBeanInfo = proxy.getMBeanInfo();
        Assert.assertEquals((long)2L, (long)mBeanInfo.getAttributes().length);
    }

    @Test
    public void testGettersWithMXBeanProxy() {
        TestingFixedThreadPoolConfigMXBean proxy = JMX.newMXBeanProxy(this.platformMBeanServer, this.threadPoolDynamicWrapperON, TestingFixedThreadPoolConfigMXBean.class);
        Assert.assertEquals((long)5L, (long)proxy.getThreadCount());
    }
}

