/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.dynamicmbean;

import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.management.ObjectName;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.config.api.annotations.AbstractServiceInterface;
import org.opendaylight.controller.config.api.annotations.Description;
import org.opendaylight.controller.config.api.annotations.RequireInterface;
import org.opendaylight.controller.config.api.annotations.ServiceInterfaceAnnotation;
import org.opendaylight.controller.config.manager.impl.dynamicmbean.AbstractDynamicWrapper;
import org.opendaylight.controller.config.manager.impl.dynamicmbean.AttributeHolder;

public class AnnotationsTest {
    private final String setSomethingString = "setSomething";
    static final String SIMPLE = "simple";
    static final String SUBCLASS2 = "subclass2";

    private void assertRequireInterfaceAnnotationHasCorrectValue(Class<?> clazz, String methodName, Set<Class<?>> inspectedInterfaces, Class<? extends AbstractServiceInterface> expectedValue) {
        Method setter = this.findMethod(clazz, methodName);
        RequireInterface found = AttributeHolder.findRequireInterfaceAnnotation((Method)setter, inspectedInterfaces);
        if (expectedValue == null) {
            Assert.assertNull((Object)found);
        } else {
            Assert.assertNotNull((Object)found);
            Assert.assertEquals(expectedValue, (Object)found.value());
        }
    }

    private Method findMethod(Class<?> clazz, String methodName) {
        Method setter;
        try {
            setter = clazz.getMethod(methodName, ObjectName.class);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        return setter;
    }

    private void assertDescription(Class<?> clazz, String methodName, Set<Class<?>> exportedInterfaces, String expectedValue) {
        Method setter = this.findMethod(clazz, methodName);
        String found = AttributeHolder.findDescription((Method)setter, exportedInterfaces);
        if (expectedValue == null) {
            Assert.assertNull((Object)found);
        } else {
            Assert.assertNotNull((Object)found);
            Assert.assertEquals((Object)expectedValue, (Object)found);
        }
    }

    private void assertDescriptionOnClass(Class<?> clazz, Set<Class<?>> jmxInterfaces, String expectedValue) {
        String found = AbstractDynamicWrapper.findDescription(clazz, jmxInterfaces);
        if (expectedValue == null) {
            Assert.assertNull((Object)found);
        } else {
            Assert.assertNotNull((Object)found);
            Assert.assertEquals((Object)expectedValue, (Object)found);
        }
    }

    private void assertNoDescriptionOnClass(Class<?> clazz, Set<Class<?>> jmxInterfaces) {
        String found = AbstractDynamicWrapper.findDescription(clazz, jmxInterfaces);
        Assert.assertTrue((boolean)found.isEmpty());
    }

    private static Set<Class<?>> emptySetOfInterfaces() {
        return Collections.emptySet();
    }

    @Test
    public void testFindAnnotation_directly() throws Exception {
        this.assertRequireInterfaceAnnotationHasCorrectValue(SuperClass.class, "setSomething", AnnotationsTest.emptySetOfInterfaces(), SimpleSI.class);
        this.assertDescription(SuperClass.class, "setSomething", AnnotationsTest.emptySetOfInterfaces(), "descr");
        this.assertDescriptionOnClass(SuperClass.class, AnnotationsTest.emptySetOfInterfaces(), "class");
    }

    @Test
    public void testFindAnnotation_subclassWithout() throws Exception {
        this.assertRequireInterfaceAnnotationHasCorrectValue(SubClassWithout.class, "setSomething", AnnotationsTest.emptySetOfInterfaces(), SimpleSI.class);
        this.assertDescription(SubClassWithout.class, "setSomething", AnnotationsTest.emptySetOfInterfaces(), "descr");
        this.assertDescriptionOnClass(SuperClass.class, AnnotationsTest.emptySetOfInterfaces(), "class");
    }

    @Test
    public void testOverridingWithoutAnnotation() throws Exception {
        this.assertRequireInterfaceAnnotationHasCorrectValue(SubClassWithEmptyMethod.class, "setSomething", AnnotationsTest.emptySetOfInterfaces(), SimpleSI.class);
        this.assertDescription(SubClassWithEmptyMethod.class, "setSomething", AnnotationsTest.emptySetOfInterfaces(), "descr");
        this.assertDescriptionOnClass(SubClassWithEmptyMethod.class, AnnotationsTest.emptySetOfInterfaces(), "class");
    }

    @Test
    public void testFindAnnotation_SubClassWithAnnotation() throws Exception {
        this.assertDescription(SubClassWithAnnotation.class, "setSomething", AnnotationsTest.emptySetOfInterfaces(), "descr2\ndescr");
        try {
            this.assertRequireInterfaceAnnotationHasCorrectValue(SubClassWithAnnotation.class, "setSomething", AnnotationsTest.emptySetOfInterfaces(), SubSI2.class);
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().startsWith("Error finding @RequireInterface. More than one value specified"));
        }
    }

    @Test
    public void testFindAnnotation_SubClassWithoutMethodWithInterface() throws Exception {
        this.assertRequireInterfaceAnnotationHasCorrectValue(SubClassWithoutMethodWithInterface.class, "setSomething", AnnotationsTest.emptySetOfInterfaces(), SimpleSI.class);
        this.assertDescription(SubClassWithoutMethodWithInterface.class, "setSomething", AnnotationsTest.emptySetOfInterfaces(), "descr");
    }

    @Test
    public void testFindAnnotation_SubClassOfSuperClassWithInterface() throws Exception {
        this.assertRequireInterfaceAnnotationHasCorrectValue(SubClassOfSuperClassWithInterface.class, "setSomething", AnnotationsTest.emptySetOfInterfaces(), SubSI2.class);
        this.assertDescription(SubClassOfSuperClassWithInterface.class, "setSomething", AnnotationsTest.emptySetOfInterfaces(), "descr");
        this.assertDescriptionOnClass(SubClassOfSuperClassWithInterface.class, AnnotationsTest.emptySetOfInterfaces(), "class");
    }

    @Test
    public void testFindAnnotation2() throws Exception {
        this.assertNoDescriptionOnClass(SuperClassWithInterface.class, AnnotationsTest.emptySetOfInterfaces());
    }

    @Test
    public void testHasSomeMethodWithAnnotationsImpl() {
        HashSet exportedInterfaces = Sets.newHashSet((Object[])new Class[]{HasSomeMethodWithAnnotations.class});
        this.assertRequireInterfaceAnnotationHasCorrectValue(HasSomeMethodWithAnnotationsImpl.class, "setSomething", exportedInterfaces, SubSI2.class);
        this.assertDescription(HasSomeMethodWithAnnotationsImpl.class, "setSomething", exportedInterfaces, "descr");
        this.assertDescriptionOnClass(HasSomeMethodWithAnnotationsImpl.class, new HashSet(Arrays.asList(HasSomeMethodWithAnnotations.class)), "class");
    }

    static class HasSomeMethodWithAnnotationsImpl
    implements HasSomeMethodWithAnnotations {
        HasSomeMethodWithAnnotationsImpl() {
        }

        @Override
        public void setSomething(ObjectName objectName) {
        }
    }

    @Description(value="class")
    static interface HasSomeMethodWithAnnotations {
        @RequireInterface(value=SubSI2.class)
        @Description(value="descr")
        public void setSomething(ObjectName var1);
    }

    @Description(value="class")
    public static class SubClassOfSuperClassWithInterface
    extends SuperClassWithInterface {
    }

    static abstract class SuperClassWithInterface
    implements HasSomeMethod {
        SuperClassWithInterface() {
        }

        @Override
        @RequireInterface(value=SubSI2.class)
        @Description(value="descr")
        public void setSomething(ObjectName objectName) {
        }
    }

    public static class SubClassWithoutMethodWithInterface
    extends SuperClass
    implements HasSomeMethod {
    }

    public static interface HasSomeMethod {
        public void setSomething(ObjectName var1);
    }

    public static class SubClassWithAnnotation
    extends SuperClass {
        @Override
        @RequireInterface(value=SubSI2.class)
        @Description(value="descr2")
        public void setSomething(ObjectName objectName) {
        }
    }

    @ServiceInterfaceAnnotation(value="subclass2", osgiRegistrationType=ExecutorService.class, namespace="ns", revision="rev", localName="subclass2")
    static interface SubSI2
    extends SubSI {
    }

    static interface SubSI
    extends SimpleSI {
    }

    public static class SubClassWithEmptyMethod
    extends SuperClass {
        @Override
        public void setSomething(ObjectName objectName) {
        }
    }

    public static class SubClassWithout
    extends SuperClass {
    }

    @Description(value="class")
    public static class SuperClass {
        @RequireInterface(value=SimpleSI.class)
        @Description(value="descr")
        public void setSomething(ObjectName objectName) {
        }
    }

    @ServiceInterfaceAnnotation(value="simple", osgiRegistrationType=Executor.class, namespace="ns", revision="rev", localName="simple")
    static interface SimpleSI
    extends AbstractServiceInterface {
    }
}

