/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.factoriesresolver;

import java.io.Closeable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.opendaylight.controller.config.manager.impl.factoriesresolver.ModuleFactoriesResolver;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class HardcodedModuleFactoriesResolver
implements ModuleFactoriesResolver {
    private Map<String, Map.Entry<ModuleFactory, BundleContext>> factories;

    public HardcodedModuleFactoriesResolver(BundleContext bundleContext, ModuleFactory ... list) {
        List<ModuleFactory> factoryList = Arrays.asList(list);
        this.factories = new HashMap<String, Map.Entry<ModuleFactory, BundleContext>>(factoryList.size());
        for (ModuleFactory moduleFactory : list) {
            StringBuffer errors = new StringBuffer();
            String moduleName = moduleFactory.getImplementationName();
            if (moduleName == null || moduleName.isEmpty()) {
                throw new IllegalStateException("Invalid implementation name for " + moduleFactory);
            }
            String error = null;
            Map.Entry<ModuleFactory, BundleContext> conflicting = this.factories.get(moduleName);
            if (conflicting != null) {
                error = String.format("Module name is not unique. Found two conflicting factories with same name '%s': \n\t%s\n\t%s\n", moduleName, conflicting.getKey(), moduleFactory);
            }
            if (error == null) {
                this.factories.put(moduleName, new AbstractMap.SimpleEntry<ModuleFactory, BundleContext>(moduleFactory, bundleContext));
            } else {
                errors.append(error);
            }
            if (errors.length() <= 0) continue;
            throw new IllegalArgumentException(errors.toString());
        }
    }

    private static BundleContext mockBundleContext() {
        BundleContext bundleContext = (BundleContext)Mockito.mock(BundleContext.class);
        ServiceRegistration serviceRegistration = (ServiceRegistration)Mockito.mock(ServiceRegistration.class);
        ((ServiceRegistration)Mockito.doNothing().when((Object)serviceRegistration)).unregister();
        ((BundleContext)Mockito.doReturn((Object)serviceRegistration).when((Object)bundleContext)).registerService((String[])Matchers.any(String[].class), Matchers.any(Closeable.class), (Dictionary)Matchers.any(Dictionary.class));
        return bundleContext;
    }

    public Map<String, Map.Entry<ModuleFactory, BundleContext>> getAllFactories() {
        return this.factories;
    }
}

