/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.osgi;

import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.opendaylight.controller.config.api.ConflictingVersionException;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.ValidationException;
import org.opendaylight.controller.config.api.jmx.CommitStatus;
import org.opendaylight.controller.config.manager.impl.osgi.BlankTransactionServiceTracker;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.osgi.framework.ServiceReference;

public class BlankTransactionServiceTrackerTest {
    @Mock
    private BlankTransactionServiceTracker.BlankTransaction blankTx;
    private BlankTransactionServiceTracker tracker;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        ((BlankTransactionServiceTracker.BlankTransaction)Mockito.doReturn((Object)new CommitStatus(Collections.emptyList(), Collections.emptyList(), Collections.emptyList())).when((Object)this.blankTx)).hit();
        this.tracker = new BlankTransactionServiceTracker(this.blankTx);
    }

    @Test
    public void testBlankTransaction() throws Exception {
        this.tracker.addingService(this.getMockServiceReference());
        this.tracker.modifiedService(this.getMockServiceReference(), null);
        this.tracker.removedService(this.getMockServiceReference(), null);
        ((BlankTransactionServiceTracker.BlankTransaction)Mockito.verify((Object)this.blankTx, (VerificationMode)Mockito.times((int)3))).hit();
    }

    @Test
    public void testValidationException() throws Exception {
        IllegalArgumentException argumentException = new IllegalArgumentException();
        ValidationException validationException = ValidationException.createForSingleException((ModuleIdentifier)new ModuleIdentifier("m", "i"), (Exception)argumentException);
        ((BlankTransactionServiceTracker.BlankTransaction)Mockito.doThrow((Throwable)validationException).when((Object)this.blankTx)).hit();
        try {
            this.tracker.addingService(this.getMockServiceReference());
        }
        catch (Exception e) {
            ((BlankTransactionServiceTracker.BlankTransaction)Mockito.verify((Object)this.blankTx, (VerificationMode)Mockito.times((int)1))).hit();
            Assert.assertNotNull((Object)e.getCause());
            Assert.assertSame((Object)validationException, (Object)e.getCause());
            return;
        }
        Assert.fail((String)"Exception should have occurred for validation exception");
    }

    @Test
    public void testConflictingException() throws Exception {
        int maxAttempts = 2;
        this.tracker = new BlankTransactionServiceTracker(this.blankTx, maxAttempts);
        ConflictingVersionException ex = new ConflictingVersionException();
        ((BlankTransactionServiceTracker.BlankTransaction)Mockito.doThrow((Throwable)ex).when((Object)this.blankTx)).hit();
        try {
            this.tracker.addingService(this.getMockServiceReference());
        }
        catch (Exception e) {
            ((BlankTransactionServiceTracker.BlankTransaction)Mockito.verify((Object)this.blankTx, (VerificationMode)Mockito.times((int)maxAttempts))).hit();
            return;
        }
        Assert.fail((String)"Exception should have occurred for conflicting exception");
    }

    private ServiceReference<ModuleFactory> getMockServiceReference() {
        return (ServiceReference)Mockito.mock(ServiceReference.class);
    }
}

