/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.osgi;

import com.google.common.util.concurrent.Futures;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.opendaylight.controller.config.manager.impl.osgi.ExtensibleBundleTracker;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class ExtensibleBundleTrackerTest {
    @Mock
    private BundleContext bundleContext;
    @Mock
    private Bundle bundle;
    @Mock
    private BundleEvent bundleEvent;
    @Mock
    private BundleTrackerCustomizer<Object> primaryTracker;
    @Mock
    private BundleTrackerCustomizer<?> additionalTracker;
    private ExtensibleBundleTracker<Object> extensibleBundleTracker;
    private Object primaryValue = new Object();

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        ((Bundle)Mockito.doReturn((Object)"bundle").when((Object)this.bundle)).toString();
        ((BundleEvent)Mockito.doReturn((Object)"bundleEvent").when((Object)this.bundleEvent)).toString();
        ((BundleTrackerCustomizer)Mockito.doReturn((Object)this.primaryValue).when(this.primaryTracker)).addingBundle(this.bundle, this.bundleEvent);
        ((BundleTrackerCustomizer)Mockito.doNothing().when(this.primaryTracker)).modifiedBundle(this.bundle, this.bundleEvent, this.primaryValue);
        ((BundleTrackerCustomizer)Mockito.doNothing().when(this.primaryTracker)).removedBundle(this.bundle, this.bundleEvent, this.primaryValue);
        ((BundleTrackerCustomizer)Mockito.doReturn((Object)new Object()).when(this.additionalTracker)).addingBundle(this.bundle, this.bundleEvent);
        ((BundleTrackerCustomizer)Mockito.doNothing().when(this.additionalTracker)).modifiedBundle(this.bundle, this.bundleEvent, null);
        ((BundleTrackerCustomizer)Mockito.doNothing().when(this.additionalTracker)).removedBundle(this.bundle, this.bundleEvent, null);
        this.extensibleBundleTracker = new ExtensibleBundleTracker(this.bundleContext, this.primaryTracker, new BundleTrackerCustomizer[]{this.additionalTracker});
    }

    @Test
    public void testAddingBundle() throws Exception {
        Assert.assertEquals((Object)this.primaryValue, this.extensibleBundleTracker.addingBundle(this.bundle, this.bundleEvent).get());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.primaryTracker, this.additionalTracker});
        ((BundleTrackerCustomizer)inOrder.verify(this.primaryTracker)).addingBundle(this.bundle, this.bundleEvent);
        ((BundleTrackerCustomizer)inOrder.verify(this.additionalTracker)).addingBundle(this.bundle, this.bundleEvent);
    }

    @Test
    public void testRemovedBundle() throws Exception {
        this.extensibleBundleTracker.removedBundle(this.bundle, this.bundleEvent, (Future)Futures.immediateFuture((Object)this.primaryValue));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.primaryTracker, this.additionalTracker});
        ((BundleTrackerCustomizer)inOrder.verify(this.primaryTracker)).removedBundle(this.bundle, this.bundleEvent, this.primaryValue);
        ((BundleTrackerCustomizer)inOrder.verify(this.additionalTracker)).removedBundle(this.bundle, this.bundleEvent, null);
    }

    @Test
    public void testRemovedBundleWithEx() throws Exception {
        IllegalStateException throwable = new IllegalStateException();
        this.extensibleBundleTracker.removedBundle(this.bundle, this.bundleEvent, (Future)Futures.immediateFailedFuture((Throwable)throwable));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.primaryTracker});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.additionalTracker});
    }
}

