/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.osgi;

import java.util.Dictionary;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.DependencyResolverFactory;
import org.opendaylight.controller.config.api.DynamicMBeanWithInstance;
import org.opendaylight.controller.config.api.annotations.AbstractServiceInterface;
import org.opendaylight.controller.config.manager.impl.osgi.BlankTransactionServiceTracker;
import org.opendaylight.controller.config.manager.impl.osgi.ModuleFactoryBundleTracker;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceRegistration;

public class ModuleFactoryBundleTrackerTest {
    @Mock
    private Bundle bundle;
    @Mock
    private BundleContext context;
    @Mock
    private ServiceRegistration<?> reg;
    @Mock
    private BlankTransactionServiceTracker blankTxTracker;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        ((Bundle)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                return this.getClass().getClassLoader().loadClass((String)invocation.getArguments()[0]);
            }
        }).when((Object)this.bundle)).loadClass(Matchers.anyString());
        ((Bundle)Mockito.doReturn((Object)"mockBundle").when((Object)this.bundle)).toString();
        ((Bundle)Mockito.doReturn((Object)this.context).when((Object)this.bundle)).getBundleContext();
        ((BundleContext)Mockito.doReturn(this.reg).when((Object)this.context)).registerService(Matchers.anyString(), Matchers.anyObject(), (Dictionary)Matchers.any(Dictionary.class));
    }

    @Test
    public void testRegisterFactory() throws Exception {
        ModuleFactoryBundleTracker.registerFactory((String)TestingFactory.class.getName(), (Bundle)this.bundle);
        ((BundleContext)Mockito.verify((Object)this.context)).registerService(ModuleFactory.class.getName(), (Object)TestingFactory.currentInstance, null);
    }

    @Test
    public void testRegisterFactoryInstantiateEx() throws Exception {
        try {
            ModuleFactoryBundleTracker.registerFactory((String)WrongConstructorTestingFactory.class.getName(), (Bundle)this.bundle);
        }
        catch (Exception e) {
            Mockito.verifyZeroInteractions((Object[])new Object[]{this.context});
            Assert.assertNotNull((Object)e.getCause());
            Assert.assertEquals(InstantiationException.class, e.getCause().getClass());
            return;
        }
        Assert.fail((String)"Cannot register without proper constructor");
    }

    @Test
    public void testRegisterFactoryInstantiateExAccess() throws Exception {
        try {
            ModuleFactoryBundleTracker.registerFactory((String)NoAccessConstructorTestingFactory.class.getName(), (Bundle)this.bundle);
        }
        catch (Exception e) {
            Mockito.verifyZeroInteractions((Object[])new Object[]{this.context});
            Assert.assertNotNull((Object)e.getCause());
            Assert.assertEquals(IllegalAccessException.class, e.getCause().getClass());
            return;
        }
        Assert.fail((String)"Cannot register without proper constructor");
    }

    @Test
    public void testRegisterFactoryNotExtending() throws Exception {
        try {
            ModuleFactoryBundleTracker.registerFactory((String)NotExtendingTestingFactory.class.getName(), (Bundle)this.bundle);
        }
        catch (Exception e) {
            Mockito.verifyZeroInteractions((Object[])new Object[]{this.context});
            return;
        }
        Assert.fail((String)"Cannot register without extend");
    }

    @Test
    public void testRegisterFactoryNotExisting() throws Exception {
        try {
            ModuleFactoryBundleTracker.registerFactory((String)"Unknown class", (Bundle)this.bundle);
        }
        catch (Exception e) {
            Mockito.verifyZeroInteractions((Object[])new Object[]{this.context});
            Assert.assertNotNull((Object)e.getCause());
            Assert.assertEquals(ClassNotFoundException.class, e.getCause().getClass());
            return;
        }
        Assert.fail((String)"Cannot register without extend");
    }

    @Test
    public void testAddingBundle() throws Exception {
        ModuleFactoryBundleTracker tracker = new ModuleFactoryBundleTracker(this.blankTxTracker);
        ((Bundle)Mockito.doReturn((Object)this.getClass().getResource("/module-factories/module-factory-ok")).when((Object)this.bundle)).getEntry(Matchers.anyString());
        tracker.addingBundle(this.bundle, (BundleEvent)Mockito.mock(BundleEvent.class));
        ((BundleContext)Mockito.verify((Object)this.context)).registerService(ModuleFactory.class.getName(), (Object)TestingFactory.currentInstance, null);
    }

    @Test
    public void testAddingBundleError() throws Exception {
        ModuleFactoryBundleTracker tracker = new ModuleFactoryBundleTracker(this.blankTxTracker);
        ((Bundle)Mockito.doReturn((Object)this.getClass().getResource("/module-factories/module-factory-fail")).when((Object)this.bundle)).getEntry(Matchers.anyString());
        try {
            tracker.addingBundle(this.bundle, (BundleEvent)Mockito.mock(BundleEvent.class));
        }
        catch (Exception e) {
            Mockito.verifyZeroInteractions((Object[])new Object[]{this.context});
            return;
        }
        Assert.fail((String)"Cannot register");
    }

    static class TestingFactory
    implements ModuleFactory {
        static TestingFactory currentInstance;

        TestingFactory() {
            currentInstance = this;
        }

        public String getImplementationName() {
            return "Testing";
        }

        public Module createModule(String instanceName, DependencyResolver dependencyResolver, BundleContext bundleContext) {
            throw new UnsupportedOperationException();
        }

        public Module createModule(String instanceName, DependencyResolver dependencyResolver, DynamicMBeanWithInstance old, BundleContext bundleContext) throws Exception {
            throw new UnsupportedOperationException();
        }

        public boolean isModuleImplementingServiceInterface(Class<? extends AbstractServiceInterface> serviceInterface) {
            throw new UnsupportedOperationException();
        }

        public Set<Class<? extends AbstractServiceInterface>> getImplementedServiceIntefaces() {
            throw new UnsupportedOperationException();
        }

        public Set<? extends Module> getDefaultModules(DependencyResolverFactory dependencyResolverFactory, BundleContext bundleContext) {
            throw new UnsupportedOperationException();
        }
    }

    static class NoAccessConstructorTestingFactory
    extends TestingFactory {
        private NoAccessConstructorTestingFactory() {
        }
    }

    static class NotExtendingTestingFactory {
        NotExtendingTestingFactory() {
        }
    }

    static class WrongConstructorTestingFactory
    extends TestingFactory {
        WrongConstructorTestingFactory(String randomParam) {
        }
    }
}

