/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.runtimembean;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.lang.management.ManagementFactory;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.config.api.runtime.HierarchicalRuntimeBeanRegistration;
import org.opendaylight.controller.config.api.runtime.RuntimeBean;
import org.opendaylight.controller.config.manager.impl.AbstractLockedPlatformMBeanServerTest;
import org.opendaylight.controller.config.manager.impl.jmx.BaseJMXRegistrator;
import org.opendaylight.controller.config.manager.impl.jmx.HierarchicalRuntimeBeanRegistrationImpl;
import org.opendaylight.controller.config.manager.impl.jmx.RootRuntimeBeanRegistratorImpl;
import org.opendaylight.controller.config.manager.impl.runtimembean.TestingRuntimeBean;

public class RuntimeBeanRegistratorImplTest
extends AbstractLockedPlatformMBeanServerTest {
    static final String module1 = "module1";
    static final String INSTANCE_NAME = "instanceName";
    String additionalKey = "key";
    String additionalValue = "value";
    Map<String, String> additionalProperties = ImmutableMap.of((Object)this.additionalKey, (Object)this.additionalValue);
    private BaseJMXRegistrator baseJMXRegistrator;
    private RootRuntimeBeanRegistratorImpl tested;
    private final ModuleIdentifier moduleIdentifier = new ModuleIdentifier("module1", "instanceName");

    @Before
    public void setUp() {
        this.baseJMXRegistrator = new BaseJMXRegistrator(ManagementFactory.getPlatformMBeanServer());
        this.tested = this.baseJMXRegistrator.createRuntimeBeanRegistrator(this.moduleIdentifier);
    }

    @After
    public void tearDown() {
        this.tested.close();
        Assert.assertEquals((long)0L, (long)this.baseJMXRegistrator.getRegisteredObjectNames().size());
    }

    protected void checkExists(ObjectName on) throws Exception {
        platformMBeanServer.getMBeanInfo(on);
    }

    protected void checkNotExists(ObjectName on) throws Exception {
        try {
            platformMBeanServer.getMBeanInfo(on);
            Assert.fail();
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testRegisterMBeanWithoutAdditionalProperties() throws Exception {
        this.createRoot();
    }

    private HierarchicalRuntimeBeanRegistrationImpl createRoot() throws Exception {
        HierarchicalRuntimeBeanRegistrationImpl rootRegistration = this.tested.registerRoot((RuntimeBean)new TestingRuntimeBean());
        ObjectName expectedON1 = ObjectNameUtil.createRuntimeBeanName((String)module1, (String)INSTANCE_NAME, (Map)Maps.newHashMap());
        Assert.assertEquals((Object)expectedON1, (Object)rootRegistration.getObjectName());
        this.checkExists(rootRegistration.getObjectName());
        return rootRegistration;
    }

    @Test
    public void testRegisterMBeanWithAdditionalProperties() throws Exception {
        HierarchicalRuntimeBeanRegistrationImpl rootRegistration = this.createRoot();
        this.createAdditional(rootRegistration);
    }

    private HierarchicalRuntimeBeanRegistration createAdditional(HierarchicalRuntimeBeanRegistrationImpl rootRegistration) throws Exception {
        HierarchicalRuntimeBeanRegistrationImpl registration = rootRegistration.register(this.additionalKey, this.additionalValue, (RuntimeBean)new TestingRuntimeBean());
        ObjectName expectedON1 = ObjectNameUtil.createRuntimeBeanName((String)module1, (String)INSTANCE_NAME, this.additionalProperties);
        Assert.assertEquals((Object)expectedON1, (Object)registration.getObjectName());
        this.checkExists(registration.getObjectName());
        return registration;
    }

    @Test
    public void testCloseRegistration() throws Exception {
        HierarchicalRuntimeBeanRegistrationImpl rootRegistration = this.createRoot();
        rootRegistration.close();
        this.checkNotExists(rootRegistration.getObjectName());
    }

    @Test
    public void testCloseRegistrator() throws Exception {
        HierarchicalRuntimeBeanRegistrationImpl rootRegistration = this.createRoot();
        HierarchicalRuntimeBeanRegistration childRegistration = this.createAdditional(rootRegistration);
        this.tested.close();
        this.checkNotExists(rootRegistration.getObjectName());
        this.checkNotExists(childRegistration.getObjectName());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegistration_overrideType() throws Exception {
        HierarchicalRuntimeBeanRegistrationImpl rootRegistration = this.createRoot();
        rootRegistration.register("type", "xxx", (RuntimeBean)new TestingRuntimeBean());
    }

    @Test
    public void testRegistrationException() throws Exception {
        HierarchicalRuntimeBeanRegistrationImpl rootRegistration = this.createRoot();
        try {
            this.createRoot();
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)rootRegistration.getObjectName().toString()));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Could not register runtime bean"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)this.moduleIdentifier.toString()));
        }
    }

    @Test
    public void testIgnoringExceptionInClose() throws Exception {
        HierarchicalRuntimeBeanRegistrationImpl rootRegistration = this.createRoot();
        platformMBeanServer.unregisterMBean(rootRegistration.getObjectName());
        rootRegistration.close();
    }
}

