/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.management.MXBean;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.config.api.annotations.AbstractServiceInterface;
import org.opendaylight.controller.config.api.annotations.ServiceInterfaceAnnotation;
import org.opendaylight.controller.config.manager.impl.util.InterfacesHelper;
import org.opendaylight.controller.config.manager.testingservices.seviceinterface.TestingScheduledThreadPoolServiceInterface;
import org.opendaylight.controller.config.manager.testingservices.seviceinterface.TestingThreadPoolServiceInterface;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.yangtools.concepts.Identifiable;

public class InterfacesHelperTest {
    @Test
    public void testGetAllInterfaces() {
        HashSet expected = Sets.newHashSet((Object[])new Class[]{SuperA.class, SuperBMXBean.class, SuperC.class, SubA.class, Identifiable.class, Module.class});
        Assert.assertEquals((Object)expected, (Object)InterfacesHelper.getAllInterfaces(SubClass.class));
    }

    @Test
    public void testGetServiceInterfaces() throws Exception {
        Assert.assertEquals(Collections.emptySet(), (Object)InterfacesHelper.getServiceInterfaces(SubClass.class));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new Class[]{Service.class, SubService.class}), (Object)InterfacesHelper.getServiceInterfaces(SubClassWithService.class));
    }

    @Test
    public void testGetOsgiRegistrationTypes() throws Exception {
        Assert.assertEquals(Collections.emptySet(), (Object)InterfacesHelper.getOsgiRegistrationTypes(SubClass.class));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new Class[]{SuperA.class, SuperC.class}), (Object)InterfacesHelper.getOsgiRegistrationTypes(SubClassWithService.class));
    }

    @Test
    public void testGetMXInterfaces() {
        HashSet expected = Sets.newHashSet((Object[])new Class[]{SuperBMXBean.class, SubA.class});
        Assert.assertEquals((Object)expected, (Object)InterfacesHelper.getMXInterfaces(SubClass.class));
    }

    @Test
    public void testGetAllAbstractServiceInterfaceClasses() {
        Class<TestingScheduledThreadPoolServiceInterface> clazz = TestingScheduledThreadPoolServiceInterface.class;
        HashSet<Class<TestingScheduledThreadPoolServiceInterface>> input = new HashSet<Class<TestingScheduledThreadPoolServiceInterface>>();
        input.add(clazz);
        Set result = InterfacesHelper.getAllAbstractServiceInterfaceClasses(input);
        ImmutableSet expected = ImmutableSet.of(TestingScheduledThreadPoolServiceInterface.class, TestingThreadPoolServiceInterface.class);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    public abstract class SubClassWithService
    implements SubService,
    Module {
    }

    public abstract class SubClass
    extends SuperClass
    implements SubA,
    Module {
    }

    @ServiceInterfaceAnnotation(value="b", osgiRegistrationType=SuperC.class, namespace="n", revision="r", localName="l")
    public static interface SubService
    extends Service {
    }

    @ServiceInterfaceAnnotation(value="a", osgiRegistrationType=SuperA.class, namespace="n", revision="r", localName="l")
    public static interface Service
    extends AbstractServiceInterface {
    }

    @MXBean
    public static interface SubA {
    }

    public class SuperClass
    implements SuperC {
    }

    public static interface SuperC
    extends SuperA,
    SuperBMXBean {
    }

    public static interface SuperBMXBean {
    }

    public static interface SuperA {
    }
}

