/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.manager.impl.util;

import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.opendaylight.controller.config.manager.impl.util.OsgiRegistrationUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.ServiceTracker;

public class OsgiRegistrationUtilTest {
    @Test
    public void testRegisterService() throws Exception {
        BundleContext bundleContext = (BundleContext)Mockito.mock(BundleContext.class);
        ServiceRegistration<?> registration = this.mockServiceRegistration();
        ((BundleContext)Mockito.doReturn(registration).when((Object)bundleContext)).registerService(String.class, (Object)"string", null);
        ServiceRegistration<?> registration2 = this.mockServiceRegistration();
        ((BundleContext)Mockito.doReturn(registration2).when((Object)bundleContext)).registerService(Object.class, (Object)"string", null);
        AutoCloseable aggregatedRegister = OsgiRegistrationUtil.registerService((BundleContext)bundleContext, (Object)"string", (Class[])new Class[]{String.class, Object.class});
        aggregatedRegister.close();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{registration, registration2});
        ((ServiceRegistration)inOrder.verify(registration2)).unregister();
        ((ServiceRegistration)inOrder.verify(registration)).unregister();
    }

    @Test
    public void testWrap() throws Exception {
        ServiceRegistration<?> serviceReg = this.mockServiceRegistration();
        OsgiRegistrationUtil.wrap(serviceReg).close();
        ((ServiceRegistration)Mockito.verify(serviceReg)).unregister();
        BundleTracker tracker = (BundleTracker)Mockito.mock(BundleTracker.class);
        ((BundleTracker)Mockito.doNothing().when((Object)tracker)).close();
        OsgiRegistrationUtil.wrap((BundleTracker)tracker).close();
        ((BundleTracker)Mockito.verify((Object)tracker)).close();
        ServiceTracker sTracker = (ServiceTracker)Mockito.mock(ServiceTracker.class);
        ((ServiceTracker)Mockito.doNothing().when((Object)sTracker)).close();
        OsgiRegistrationUtil.wrap((ServiceTracker)sTracker).close();
        ((ServiceTracker)Mockito.verify((Object)sTracker)).close();
    }

    private ServiceRegistration<?> mockServiceRegistration() {
        ServiceRegistration mock = (ServiceRegistration)Mockito.mock(ServiceRegistration.class);
        ((ServiceRegistration)Mockito.doNothing().when((Object)mock)).unregister();
        return mock;
    }

    @Test
    public void testAggregate() throws Exception {
    }
}

